/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2015. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
/**
* Licensed Materials - Property of IBM
* 5748-XX8
* (C) Copyright IBM Corp. 2013, 2014 All Rights Reserved
* US Government Users Restricted Rights - Use, duplication or
* disclosure restricted by GSA ADP Schedule Contract with
* IBM Corp.
**/

import com.urbancode.air.AirPluginTool;
import com.ibm.rational.air.plugin.worklight.Util;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties();

def serverpath = props['serverpath']
def runtime = props['runtime']
def wlapps = Util.text2List(props['wlapp'])
def worklightAntJar = props['worklightAntJar']
def user = props['user']
def password = props['password']
boolean secure = Boolean.parseBoolean(props['secure']?: "true")

try {
    println "Deploying the Worklight application with the following properties:"
    println "Server Path: ${serverpath}"
    println "Application(s): ${wlapps}"
    println "Worklight Ant Deployer JAR Path: ${worklightAntJar}"

    for (wlapp in wlapps) {
        File wlappFile = new File(wlapp)
        def fileName = wlappFile.getName()
        if (!wlappFile.isFile()) {
            println "Error: The Worklight application file name given does not exist. " +
                "Please enter a valid file path and name: ${fileName}."
            System.exit(-1)
        }
        int extension = fileName.lastIndexOf(".")
        if(extension == -1 || fileName.substring(extension) != ".wlapp") {
            println "Error: The Worklight application file name must include the .wlapp " +
                "extension: ${wlappFile.getName()}. For example, file.wlapp."
            System.exit(-1)
        }
    }
    File worklightAntJarFile = new File(worklightAntJar)
    if(!worklightAntJarFile.exists() || !worklightAntJarFile.isFile() ||
        !Util.isWorklightDeployerAntJar(worklightAntJarFile)) {
        println "Error: The path to the Worklight Ant Deployer JAR file is invalid: " +
                "${worklightAntJarFile.getCanonicalPath()}. Change the value of the " +
                "Worklight Ant JAR File Path attribute to the path to the Worklight " +
                "Ant Deployer JAR file. For example, use " +
                "/opt/IBM/Worklight/WorklightServer/worklight-ant-deployer.jar."
        System.exit(-1)
    }

    for (wlapp in wlapps) {
        def serverVersion = Util.determineServerVersion(worklightAntJarFile, serverpath, user,
            password, secure);
        if(serverVersion == Util.WL_SERVER_60 || serverVersion == Util.WL_SERVER_61) {
            def ant = new AntBuilder();
            try {
                ant.taskdef ( name: "deployer",
                    classname:"com.worklight.ant.deployers.ApplicationDeployerTask",
                    classpath: worklightAntJarFile.absolutePath )
            } catch (Exception e) {
                println "Error: The class com.worklight.ant.deployers.ApplicationDeployerTask " +
                        "is not found in the specified Worklight Ant Deployer JAR file: " +
                        "${worklightAntJarFile.getCanonicalPath()}."
                println "Explanation: This error occurs if the JAR file specified in the " +
                        "Worklight Ant JAR File Path attribute is not correct."
                println "User response: Change the value of the Worklight Ant JAR File Path " +
                        "attribute to the path to the Worklight Ant Deployer JAR file. For " +
                        "example, use " +
                        "/opt/IBM/Worklight/WorklightServer/worklight-ant-deployer.jar."
                System.exit(-1)
            }
            if(user?.trim()) {
                if(password?.trim()) {
                    ant.deployer ( worklightServerHost:serverpath, deployable:wlapp,
                        userName:user, password:password )
                }
                else {
                    println "Error: A password must be provided for the user."
                    System.exit(-1)
                }
            } else {
                ant.deployer ( worklightServerHost:serverpath, deployable:wlapp )
            }
        } else if ( serverVersion == Util.WL_SERVER_62  ||
                    serverVersion == Util.WL_SERVER_63  ||
                    serverVersion == Util.WL_SERVER_70  ||
                    serverVersion == Util.WL_SERVER_71
                ) {
            def ant = Util.getWLADMAnt(worklightAntJarFile);
            ant.wladm ( url:serverpath, user:user, password:password, secure:secure) {
                'deploy-app' ( runtime:runtime, file:wlapp )
            }
        } else {
            if(serverVersion) {
                println "Error: The Worklight Server version is not supported.";
            } else {
                println "Error: The Worklight Server version could not be determined or there " +
                    "is a mismatch between the Worklight Ant Deployer JAR and the server.";
                println "Explanation: This error can occur if the Worklight Server Path specified " +
                    "in the Server Path attribute is not correct or the path to the Worklight Ant " +
                    "Deployer JAR specified in the Worklight Ant JAR File Path attribute is not " +
                    "correct.";
                println "User response: Verify the path specified by the Server Path attribute is " +
                    "correct. For example, use http://localhost:9080/worklight on Worklight " +
                    "6.0 or 6.1 Servers, or https://localhost:9443/worklightadmin on Worklight " +
                    "6.2 Servers. Verify the JAR file specified in the Worklight Ant JAR File " +
                    "Path attribute uses the JAR from the corresponding Worklight Server. For " +
                    "example, use /opt/IBM/Worklight/WorklightServer/worklight-ant-deployer.jar.";
            }
            System.exit(-1)
        }
    }
} catch (Exception e) {
    println "An error occurred while deploying the Worklight application: ${e.message}"
    System.exit(-1)
}

println "The Deploy Worklight Application to Worklight Server step completed successfully."
System.exit(0)