/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties();

def serverpath = props['serverpath']
def context = props['context']
def user = props['user']
def password = props['password']
def desc = props['desc']
def label = props['label']
boolean isActive = Boolean.parseBoolean(props['isActive'])
boolean isInstaller = Boolean.parseBoolean(props['isInstaller'])
boolean isReadyForProduction = Boolean.parseBoolean(props['isReadyForProduction'])
boolean isRecommended = Boolean.parseBoolean(props['isRecommended'])
boolean force = Boolean.parseBoolean(props['force'])
boolean disableSSL = Boolean.parseBoolean(props['disableSSL'])
def file = props['file']
def appCenterJar = props['appCenterJar']
def json4jJar = props['json4jJar']

try {
    println "Uploading the application with the following properties:"
    println "Server Path: ${serverpath}"
    println "Context: ${context}"
    if(desc != null)
        println "Description: ${desc}"
    if(label != null)
        println "Label: ${label}"
    println "Active: ${isActive}"
    println "Installer: ${isInstaller}"
    println "Ready for production: ${isReadyForProduction}"
    println "Recommended: ${isRecommended}"
    println "Force Upload: ${force}"
    println "Disable SSL: ${disableSSL}"
    println "File: ${file}"
    println "Application Center Deploy Tool JAR: ${appCenterJar}"
    println "JSON4J JAR: ${json4jJar}"
    println ""

    if(serverpath == null || context == null || serverpath.trim().length() == 0 || context.trim().length() == 0) {
        println "Error: You must specify both the server path and the server context."
        System.exit(1)
    }

    File filePath = new File(file)
    def fileName = new File(file).getName()
    int extension = fileName.lastIndexOf(".")
    if(extension == -1 || (fileName.substring(extension) != ".apk" && fileName.substring(extension) != ".ipa")) {
        println "Error: The application file name must include either the .apk or .ipa extension: ${fileName}. For example, file.apk."
        System.exit(1)
    }

    if(context.charAt(0) != '/' && !serverpath.endsWith("/")) {
        context = "/" + context
    }

    File appCenterJarFile = new File(appCenterJar)
    if(!appCenterJarFile.exists() || !appCenterJarFile.isFile()) {
        println "Error: The path to the Application Center Deploy Tool Ant JAR file is invalid: " +
                "${appCenterJarFile.getCanonicalPath()}. Change the value of the Application " +
                "Center Ant JAR File Path attribute to the path to the Application Center Ant " +
                "JAR file. For example, use " +
                "/opt/IBM/Worklight/ApplicationCenter/tools/applicationcenterdeploytool.jar."
        System.exit(1)
    }

    File json4jJarFile = new File(json4jJar)
    if(!json4jJarFile.exists() || !json4jJarFile.isFile()) {
        println "Error: The path to the JSON4J JAR file is invalid: " +
                "${json4jJarFile.getCanonicalPath()}. Change the value of the JSON4J JAR File " +
                "Path attribute to the path to the JSON4J JAR file. For example, use " +
                "/opt/IBM/Worklight/ApplicationCenter/tools/json4j.jar."
        System.exit(1)
    }

    def taskdefClasspath = appCenterJarFile.absolutePath + ":" + json4jJarFile.absolutePath
    def ant = new AntBuilder();
    try {
        ant.taskdef ( name: "uploadApp", classname:"com.ibm.appcenter.ant.UploadApps", classpath: taskdefClasspath )
    } catch (Exception e) {
        println "Error: The class com.ibm.appcenter.ant.UploadApps is not found in " +
                "the specified Application Center Deploy Tool Ant JAR file: " +
                "${appCenterJarFile.getCanonicalPath()}."
        println "Explanation: This error occurs if the JAR file specified in the " +
                "Worklight Ant JAR File Path attribute is not correct."
        println "User response: Change the value of the Application Center Deploy " +
                "Tool Ant JAR File Path attribute to the path to the Application " +
                "Center Deploy Tool Ant JAR file. For example, use " +
                "/opt/IBM/Worklight/ApplicationCenter/tools/applicationcenterdeploytool.jar. " +
                "Also, confirm that the path to the JSON4J JAR file value is " +
                "correctly specified in the JSON4J JAR File Path attribute: " +
                "${json4jJarFile.getCanonicalPath()}. For example, use " +
                "/opt/IBM/Worklight/ApplicationCenter/tools/json4j.jar."
        System.exit(1)
    }
    ant.uploadApp ( serverPath:serverpath, context:context, loginUser:user, loginPass:password,
         description:desc, fallbackLabel:label, active:isActive, installer:isInstaller,
         readyForProduction:isReadyForProduction, recommended:isRecommended, forceOverwrite:force,
         disableSSLSecurity:disableSSL, file:filePath )
} catch (Exception e) {
    println "An error occurred while uploading the application: ${e.message}"
    System.exit(1)
}

println "The Upload Application to Application Center step completed successfully."
