--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

-- To execute this script:
-- Let's assume the database should be created in a directory /var/ibm/Worklight/derby.
-- Let's assume the database should be named WRKLGHT.
-- Let's assume the database schema should be named WORKLIGHT.
-- Start the ij interpreter. Then type on its command line:
-- connect 'jdbc:derby:/var/ibm/Worklight/derby/WRKLGHT;user=WORKLIGHT;create=true';
-- run 'create-worklight-derby.sql';
-- quit;

CREATE TABLE ADAPTER_SYNC_DATA (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, deployable BLOB(2G) NOT NULL, deployableHash VARCHAR(255) NOT NULL, deployableKey VARCHAR(255) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_deployableKey UNIQUE (deployableKey));
CREATE TABLE APP_SYNC_DATA (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, appDeployableKey VARCHAR(255) NOT NULL, deployable BLOB(2G) NOT NULL, deployableHash VARCHAR(255) NOT NULL, lastPersistentPropertyChange BIGINT NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_appDeployableKey UNIQUE (appDeployableKey));
CREATE TABLE APP_VERSION_ACCESS_DATA (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, ACTION VARCHAR(255) NOT NULL, CREATED_TIME TIMESTAMP NOT NULL, DOWNLOAD_LINK VARCHAR(255), ENV VARCHAR(255) NOT NULL, GADGET_NAME VARCHAR(255) NOT NULL, MESSAGE VARCHAR(255) NOT NULL, VERSION VARCHAR(255) NOT NULL, MULTILANGUAGE_MESSAGES CLOB(1M), PRIMARY KEY (ID), CONSTRAINT UNQ_GADGET_NAMENVVERSION UNIQUE (GADGET_NAME, ENV, VERSION));
CREATE TABLE AUTH_ASSOCIATED_IDENTITY (FROMLOGINMODULE VARCHAR(255) NOT NULL, FROMUSERID VARCHAR(255) NOT NULL, TOLOGINMODULE VARCHAR(255) NOT NULL, LASTACCESS BIGINT, TOIDENTITYSTR VARCHAR(21300), TOUSERID VARCHAR(255), PRIMARY KEY (FROMLOGINMODULE, FROMUSERID, TOLOGINMODULE));
CREATE TABLE CLUSTER_SYNC (ID VARCHAR(255) NOT NULL, HOSTVMID VARCHAR(255), UPDATETIMESTAMP BIGINT, VERSION BIGINT NOT NULL, PRIMARY KEY (ID));
CREATE TABLE GADGETS (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, DISP_IN_GALLERY SMALLINT, LAST_UPDATE_TIME TIMESTAMP NOT NULL, NAME VARCHAR(255) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_ UNIQUE (NAME));
CREATE TABLE GADGET_APPLICATIONS (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, ENFORCE_AUTHENTICITY SMALLINT, ENVIRONMENT_ID VARCHAR(255) NOT NULL, SERVER_VERSION VARCHAR(255) NOT NULL, VERSION VARCHAR(255) NOT NULL, VERSION_LOCKED SMALLINT, GADGET_ID BIGINT NOT NULL, PRIMARY KEY (ID));
CREATE TABLE GADGET_USER (GADGET_APP_ID VARCHAR(255) NOT NULL, USER_ID VARCHAR(255) NOT NULL, FIRST_ACCESS_TIME DATE NOT NULL, GADGET_ID VARCHAR(255) NOT NULL, PRIMARY KEY (GADGET_APP_ID, USER_ID));
CREATE TABLE GADGET_USER_PREF (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, GADGET_APP_ID VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, USER_ID VARCHAR(255), VALUE VARCHAR(255) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_APPLICATION (APPLICATIONID VARCHAR(255) NOT NULL, MEDIATORTYPE SMALLINT NOT NULL, PLATFORMSTR VARCHAR(255) NOT NULL, dataStr CLOB, ENABLED SMALLINT, PRIMARY KEY (APPLICATIONID, MEDIATORTYPE, PLATFORMSTR));
CREATE TABLE NOTIFICATION_DEVICE (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, ALIAS VARCHAR(255), APPLICATIONID VARCHAR(255) NOT NULL, DEVICE VARCHAR(255) NOT NULL, OPTIONS VARCHAR(255), PLATFORM VARCHAR(255) NOT NULL, TOKEN VARCHAR(255) NOT NULL, USERAGENT VARCHAR(255) NOT NULL, USERSUBSCRIPTIONID BIGINT NOT NULL, PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_MEDIATOR (MEDIATORSTR VARCHAR(255) NOT NULL, stateStr CLOB, PRIMARY KEY (MEDIATORSTR));
CREATE TABLE NOTIFICATION_USER (ID BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY, EVENTSOURCE VARCHAR(255) NOT NULL, STATE VARCHAR(255), USERID VARCHAR(255) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_USERIDEVENTSOURCE UNIQUE (USERID, EVENTSOURCE));
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID SMALLINT NOT NULL, SEQUENCE_VALUE BIGINT, PRIMARY KEY (ID));
CREATE TABLE PROPERTIES (PROPERTY VARCHAR(255) NOT NULL, VALUE VARCHAR(255), PRIMARY KEY (PROPERTY));
CREATE TABLE SSO_LOGIN_CONTEXTS (DEVICE_ID VARCHAR(254) NOT NULL, DEVICE_LOGIN_MODULE VARCHAR(254) NOT NULL, SSO_LOGIN_MODULE VARCHAR(254) NOT NULL, LOGIN_CONTEXT BLOB(1M), EXPIRES TIMESTAMP NOT NULL, PRIMARY KEY (DEVICE_ID, DEVICE_LOGIN_MODULE, SSO_LOGIN_MODULE));
CREATE TABLE USAGE_DATA (TIME_AT_BEGINING_OF_DAY BIGINT NOT NULL, USER_ID VARCHAR(255) NOT NULL, EXACT_LOGIN_TIME BIGINT, PRIMARY KEY (TIME_AT_BEGINING_OF_DAY, USER_ID));
CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL);
CREATE INDEX I_GDGTTNS_GADGET ON GADGET_APPLICATIONS (GADGET_ID);
CREATE INDEX I_NTFCDVC_PARENT ON NOTIFICATION_DEVICE (USERSUBSCRIPTIONID);
CREATE INDEX I_NTFCDVC_DEVICE ON NOTIFICATION_DEVICE (DEVICE);

-- TODO: put the correct version value in here when we know what it is

INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM SYSIBM.SYSDUMMY1 WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);
