--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

SELECT SEQUENCE_OWNER AS SEQUENCE_SCHEMA, SEQUENCE_NAME FROM ALL_SEQUENCES;
CREATE SEQUENCE ADAPTER_SYNC_DATA_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE APP_SYNC_DATA_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE APP_VERSION_ACCESS_DATA_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE GADGETS_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE GADGET_APPLICATIONS_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE NOTIFICATION_DEVICE_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE NOTIFICATION_USER_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE USER_PREF_SEQ START WITH 1 CACHE 50;
CREATE TABLE ADAPTER_SYNC_DATA (ID NUMBER(19,0) NOT NULL, deployable BLOB NOT NULL, deployableHash VARCHAR2(255) NOT NULL, deployableKey VARCHAR2(255) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_deployableKey UNIQUE (deployableKey) DEFERRABLE);
CREATE TABLE APP_SYNC_DATA (ID NUMBER(19,0) NOT NULL, appDeployableKey VARCHAR2(255) NOT NULL, deployable BLOB NOT NULL, deployableHash VARCHAR2(255) NOT NULL, lastPersistentPropertyChange NUMBER(19,0) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_appDeployableKey UNIQUE (appDeployableKey) DEFERRABLE);
CREATE TABLE APP_VERSION_ACCESS_DATA (ID NUMBER(19,0) NOT NULL, ACTION VARCHAR2(255) NOT NULL, CREATED_TIME TIMESTAMP NOT NULL, DOWNLOAD_LINK VARCHAR2(255), ENV VARCHAR2(255) NOT NULL, GADGET_NAME VARCHAR2(255) NOT NULL, MESSAGE VARCHAR2(255) NOT NULL, VERSION VARCHAR2(255) NOT NULL, MULTILANGUAGE_MESSAGES CLOB, PRIMARY KEY (ID), CONSTRAINT UNQ_GADGET_NAMENVVERSION UNIQUE (GADGET_NAME, ENV, VERSION) DEFERRABLE);
CREATE TABLE AUTH_ASSOCIATED_IDENTITY (FROMLOGINMODULE VARCHAR2(255) NOT NULL, FROMUSERID VARCHAR2(255) NOT NULL, TOLOGINMODULE VARCHAR2(255) NOT NULL, LASTACCESS NUMBER(19,0), TOIDENTITYSTR CLOB, TOUSERID VARCHAR2(255), PRIMARY KEY (FROMLOGINMODULE, FROMUSERID, TOLOGINMODULE));
CREATE TABLE CLUSTER_SYNC (ID VARCHAR2(255) NOT NULL, HOSTVMID VARCHAR2(255), UPDATETIMESTAMP NUMBER(19,0), VERSION NUMBER(19,0) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE GADGETS (ID NUMBER(19,0) NOT NULL, DISP_IN_GALLERY NUMBER, LAST_UPDATE_TIME TIMESTAMP NOT NULL, NAME VARCHAR2(255) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_ UNIQUE (NAME) DEFERRABLE);
CREATE TABLE GADGET_APPLICATIONS (ID NUMBER(19,0) NOT NULL, ENFORCE_AUTHENTICITY NUMBER, ENVIRONMENT_ID VARCHAR2(255) NOT NULL, SERVER_VERSION VARCHAR2(255) NOT NULL, VERSION VARCHAR2(255) NOT NULL, VERSION_LOCKED NUMBER, GADGET_ID NUMBER(19,0) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE GADGET_USER (GADGET_APP_ID VARCHAR2(255) NOT NULL, USER_ID VARCHAR2(255) NOT NULL, FIRST_ACCESS_TIME DATE NOT NULL, GADGET_ID VARCHAR2(255) NOT NULL, PRIMARY KEY (GADGET_APP_ID, USER_ID));
CREATE TABLE GADGET_USER_PREF (ID NUMBER(19,0) NOT NULL, GADGET_APP_ID VARCHAR2(255) NOT NULL, NAME VARCHAR2(255) NOT NULL, USER_ID VARCHAR2(255), VALUE CLOB, PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_APPLICATION (APPLICATIONID VARCHAR2(255) NOT NULL, MEDIATORTYPE NUMBER NOT NULL, PLATFORMSTR VARCHAR2(255) NOT NULL, dataStr CLOB, ENABLED NUMBER, PRIMARY KEY (APPLICATIONID, MEDIATORTYPE, PLATFORMSTR));
CREATE TABLE NOTIFICATION_DEVICE (ID NUMBER(19,0) NOT NULL, ALIAS VARCHAR2(255), APPLICATIONID VARCHAR2(255) NOT NULL, DEVICE VARCHAR2(255) NOT NULL, OPTIONS VARCHAR2(255), PLATFORM VARCHAR2(255) NOT NULL, TOKEN VARCHAR2(255) NOT NULL, USERAGENT VARCHAR2(255) NOT NULL, USERSUBSCRIPTIONID NUMBER(19,0) NOT NULL, PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_MEDIATOR (MEDIATORSTR VARCHAR2(255) NOT NULL, stateStr CLOB, PRIMARY KEY (MEDIATORSTR));
CREATE TABLE NOTIFICATION_USER (ID NUMBER(19,0) NOT NULL, EVENTSOURCE VARCHAR2(255) NOT NULL, state CLOB, USERID VARCHAR2(255) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_USERIDEVENTSOURCE UNIQUE (USERID, EVENTSOURCE) DEFERRABLE);
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID NUMBER NOT NULL, SEQUENCE_VALUE NUMBER(19,0), PRIMARY KEY (ID));
CREATE TABLE PROPERTIES (PROPERTY VARCHAR2(255) NOT NULL, VALUE VARCHAR2(255), PRIMARY KEY (PROPERTY));
CREATE TABLE SSO_LOGIN_CONTEXTS (DEVICE_ID VARCHAR2(255) NOT NULL, DEVICE_LOGIN_MODULE VARCHAR2(255) NOT NULL, SSO_LOGIN_MODULE VARCHAR2(255) NOT NULL, LOGIN_CONTEXT CLOB, EXPIRES TIMESTAMP NOT NULL, PRIMARY KEY (DEVICE_ID, DEVICE_LOGIN_MODULE, SSO_LOGIN_MODULE));
CREATE TABLE USAGE_DATA (TIME_AT_BEGINING_OF_DAY NUMBER(19,0) NOT NULL, USER_ID VARCHAR2(255) NOT NULL, EXACT_LOGIN_TIME NUMBER(19,0), PRIMARY KEY (TIME_AT_BEGINING_OF_DAY, USER_ID));
CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL);
INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM DUAL WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);
CREATE INDEX I_GDGTTNS_GADGET ON GADGET_APPLICATIONS (GADGET_ID);
CREATE INDEX I_NTFCDVC_PARENT ON NOTIFICATION_DEVICE (USERSUBSCRIPTIONID);
CREATE INDEX I_NTFCDVC_DEVICE ON NOTIFICATION_DEVICE (DEVICE);

