--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

-- To execute this script:
-- Let's assume the database should be created in a directory /var/ibm/Worklight/derby.
-- Let's assume the database should be named WLREPORT.
-- Let's assume the database schema should be named WORKLIGHT.
-- Start the ij interpreter. Then type on its command line:
-- connect 'jdbc:derby:/var/ibm/Worklight/derby/WLREPORT;user=WORKLIGHT;create=true';
-- run 'create-worklight-derby.sql';
-- quit;

CREATE TABLE ACTIVITIES_CUBE (AID BIGINT NOT NULL, ACTIVITY_DATE DATE, APP_NAME VARCHAR(255), APP_VERSION VARCHAR(255), DEVICE_ID VARCHAR(255), ENVIRONMENT VARCHAR(255), TOTAL_ACTIVITY BIGINT, PRIMARY KEY (AID));
CREATE TABLE APP_ACTIVITY_REPORT (ID BIGINT NOT NULL, ACTIVITY VARCHAR(4000), ACTIVITY_TIMESTAMP TIMESTAMP, ADAPTER VARCHAR(255), DEVICE_ID VARCHAR(255), DEVICE_MODEL VARCHAR(255), DEVICE_OS VARCHAR(255), ENVIRONMENT VARCHAR(255), GADGET_NAME VARCHAR(255), GADGET_VERSION VARCHAR(255), IP_ADDRESS VARCHAR(255), PROC VARCHAR(255), SESSION_ID VARCHAR(255), SOURCE VARCHAR(255), USER_AGENT VARCHAR(255), LONGITUDE DOUBLE, LATITUDE DOUBLE, POS_USER_TIME TIMESTAMP, WIFI_APS VARCHAR(4000), WIFI_CONNECTED_SSID VARCHAR(32), WIFI_CONNECTED_MAC CHAR(20), WIFI_USER_TIME TIMESTAMP, APP_CONTEXT VARCHAR(4000), PRIMARY KEY (ID));
CREATE TABLE FACT_ACTIVITIES (AID VARCHAR(255) NOT NULL, ACTIVITY_DATE DATE, APP_NAME VARCHAR(255), APP_VERSION VARCHAR(255), DEVICE_ID VARCHAR(255), DEVICE_MODEL VARCHAR(255), DEVICE_OS VARCHAR(255), ENVIRONMENT VARCHAR(255), TOTAL_ACTIVITY INTEGER, PRIMARY KEY (AID));
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID SMALLINT NOT NULL, SEQUENCE_VALUE BIGINT, PRIMARY KEY (ID));
CREATE TABLE PROC_REPORT (ID INTEGER NOT NULL, NUM_PROCESSED INTEGER, PROC_TIMESTAMP TIMESTAMP, PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_REPORT (ID BIGINT NOT NULL, APP_NAME VARCHAR(255), DESTINATION_NUMBER VARCHAR(255), EVENT_SOURCE VARCHAR(255), MEDIATOR VARCHAR(255), MESSAGE_COUNT INTEGER, NOTIFICATION_TIMESTAMP TIMESTAMP, SENDER_ID VARCHAR(255), SUBSCRIPTION_PROPERTIES VARCHAR(255), PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_ACTIVITIES (SID VARCHAR(255) NOT NULL, EVENT_SOURCE VARCHAR(255), MEDIATOR VARCHAR(255), NOTIFICATION_DATE DATE, TOTAL_NOTIFICATIONS INTEGER, PRIMARY KEY (SID));
CREATE TABLE NOTIFICATION_PROC_REPORT (ID INTEGER NOT NULL, NUM_PROCESSED INTEGER, PROC_TIMESTAMP TIMESTAMP, PRIMARY KEY (ID));

CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL);
INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM SYSIBM.SYSDUMMY1 WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);
