/*
 * Licensed Materials - Property of IBM
 * 5725-G92 (C) Copyright IBM Corp. 2006, 2013. All Rights Reserved.
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

var WL = WL || {};

WL.namespace = function (ns_string) {
	var parts = ns_string.split('.'),
	parent = WL,
	i;

	if (parts[0] === "WL") {
		parts = parts.slice(1);
	}

	for (i = 0; i < parts.length; i += 1) {
		if (typeof parent[parts[i]] === "undefined") {
			parent[parts[i]] = {};
		}
		parent = parent[parts[i]];
	}

	return parent;
};

WL.namespace('WL.Analytics');
WL.Analytics = (function (global) {

	"use strict";
	var consoleURL = null,
		consolePath = "/iwap/worklight/v1/index.html";

	$('#analyticsOpenNewTab').live('click', function(){
		if(consoleURL != null){
			var hostName = __parseConsoleURL(consoleURL);
			var actualURL = hostName + consolePath;
			window.open(actualURL);
		}
	});

	var _displayAnalyticsConsole = function(){
		// TODO check if URL exists?
		if(consoleURL != null){
			var hostName = __parseConsoleURL(consoleURL);
			var actualURL = hostName + consolePath;
			
			var iFrame = $('<iframe/>', {src:actualURL, height: "800px", width:"100%"});
			$("#analytics #iframe_div").append(iFrame);
		}
	}, 
	
	__parseConsoleURL = function(url){
		var m = url.match(/^(http|https):\/\/[^/]+/);
		return m ? m[0] : "";
	},
	
	_setConsoleURL = function(url){
		consoleURL = url;
	},

	_hideAnalyticsTab = function(){
		$("#analyticsLi").hide();
	};

	//public API
	return {
		displayAnalyticsConsole: _displayAnalyticsConsole,
		hideAnalyticsTab: _hideAnalyticsTab,
		setConsoleURL: _setConsoleURL
	};

}(window));
