--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

--
-- ADAPTER_SYNC_DATA
--

CREATE TABLE ADAPTER_SYNC_DATA (ID BIGINT NOT NULL AUTO_INCREMENT, deployable LONGBLOB NOT NULL, deployableHash VARCHAR(255) NOT NULL, deployableKey VARCHAR(255) NOT NULL, PRIMARY KEY (ID), UNIQUE UNQ_deployableKey (deployableKey)) ENGINE = innodb;

--
-- APP_SYNC_DATA
--

CREATE TABLE APP_SYNC_DATA (ID BIGINT NOT NULL AUTO_INCREMENT, appDeployableKey VARCHAR(255) NOT NULL, deployable LONGBLOB NOT NULL, deployableHash VARCHAR(255) NOT NULL, lastPersistentPropertyChange BIGINT NOT NULL, PRIMARY KEY (ID), UNIQUE UNQ_appDeployableKey (appDeployableKey)) ENGINE = innodb;

--
-- APP_VERSION_ACCESS_DATA
--

-- Rename ENVIRONMENT to ENV.

ALTER TABLE WORKLIGHT42.APP_VERSION_ACCESS_DATA CHANGE COLUMN ENVIRONMENT ENV VARCHAR (255) NOT NULL; 

-- Remove (GADGET_NAME,ENVIRONMENT_VERSION) unique constraint and add a
-- replacement.

ALTER TABLE WORKLIGHT42.APP_VERSION_ACCESS_DATA DROP KEY GADGET_NAME;
ALTER TABLE WORKLIGHT42.APP_VERSION_ACCESS_DATA ADD CONSTRAINT UNQ_GADGET_NAMENVVERSION UNIQUE (GADGET_NAME, ENV, VERSION) ; 

--
-- AUTH_ASSOCIATED_IDENTITY
--

--
-- CLUSTER_SYNC
--

--
-- GADGET_APPLICATIONS
--

DROP TABLE IF EXISTS WORKLIGHT42.GADGET_APPLICATIONS;

CREATE TABLE GADGET_APPLICATIONS (ID BIGINT NOT NULL AUTO_INCREMENT, ENFORCE_AUTHENTICITY BIT, ENVIRONMENT_ID VARCHAR(255) NOT NULL, SERVER_VERSION VARCHAR(255) NOT NULL, VERSION VARCHAR(255) NOT NULL, VERSION_LOCKED BIT, GADGET_ID BIGINT NOT NULL, PRIMARY KEY (ID)) ENGINE = innodb;

CREATE INDEX I_GDGTTNS_GADGET ON GADGET_APPLICATIONS (GADGET_ID);

--
-- GADGET_USER
--

-- Drop GADGET_INSTANCE_ID.

-- Don't drop in 4.2.2
-- ALTER TABLE WORKLIGHT42.GADGET_USER DROP KEY GADGET_INSTANCE_ID;

-- Add GADGET_APP_ID and GADGET_ID.

ALTER TABLE WORKLIGHT42.GADGET_USER ADD GADGET_APP_ID VARCHAR (255) NOT NULL; 
ALTER TABLE WORKLIGHT42.GADGET_USER ADD GADGET_ID VARCHAR (255) NOT NULL;

--
-- GADGET_USER_PREF
--

-- Drop GADGET_INSTANCE_ID.

-- Don't drop in 4.2.2
-- ALTER TABLE WORKLIGHT42.GADGET_USER_PREF DROP KEY GADGET_INSTANCE_ID;

-- Add GADGET_APP_ID.

ALTER TABLE WORKLIGHT42.GADGET_USER_PREF ADD GADGET_APP_ID VARCHAR (255) NOT NULL; 

--
-- GADGETS
--

--
-- NOTIFICATION_APPLICATION
--

-- Add MEDIATORTYPE and ENABLED.

ALTER TABLE WORKLIGHT42.NOTIFICATION_APPLICATION ADD MEDIATORTYPE SMALLINT NOT NULL; 
ALTER TABLE WORKLIGHT42.NOTIFICATION_APPLICATION ADD ENABLED BIT NULL; 

--
-- NOTIFICATION_DEVICE
--

-- Drop and replace index.

DROP INDEX DEVICE_IDX ON WORKLIGHT42.NOTIFICATION_DEVICE;
CREATE INDEX I_NTFCDVC_PARENT USING BTREE ON WORKLIGHT42.NOTIFICATION_DEVICE(DEVICE ASC);

--
-- NOTIFICATION_MEDIATOR
--

--
-- NOTIFICATION_USER
--

--
-- OPENJPA_SEQUENCE_TABLE
--

CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID TINYINT NOT NULL, SEQUENCE_VALUE BIGINT, PRIMARY KEY (ID)) ENGINE = innodb;

--
-- PROPERTIES
--

--
-- USAGE_DATA
--

--
-- WORKLIGHT_VERSION
--

CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL) ENGINE = innodb;
INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM DUAL WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);

