#!/bin/sh

# Licensed Materials - Property of IBM
# 5725-G92 (C) Copyright IBM Corp. 2011, 2013 . All Rights Reserved.
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

url='@URL@'

case `uname -s` in
  Darwin*)
    # Mac OS X has 'open'.
    exec open "$url"
    ;;
  *)
    if (type xdg-open) >/dev/null 2>/dev/null; then
      # Linux has 'xdg-open' and 'sensible-browser'.
      # The behaviour of 'xdg-open' can be customized through the 'xdg-settings'
      # program; for details, run 'xdg-settings --manual'.
      exec xdg-open "$url"
    else
      # Use firefox if it is available.
      if (type firefox) >/dev/null 2>/dev/null; then
        exec firefox "$url"
      else
        # Use konqueror if it is available.
        if (type rekonq) >/dev/null 2>/dev/null; then
          exec rekonq "$url"
        else
          if (type kfmclient) >/dev/null 2>/dev/null; then
            exec kfmclient openURL "$url"
          else
            # Use 'sensible-browser' as a fallback. It fails if it cannot find a browser.
            exec sensible-browser "$url"
          fi
        fi
      fi
    fi
    ;;
esac
