--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

--
-- Procedures
--

CREATE OR REPLACE PROCEDURE dropConstraintByName (tableName IN VARCHAR2, columnName IN VARCHAR2, constraintType IN VARCHAR2) IS
     temp VARCHAR2(30);
BEGIN
     SELECT c.CONSTRAINT_NAME INTO temp FROM USER_CONSTRAINTS c, USER_CONS_COLUMNS cc WHERE c.CONSTRAINT_NAME = cc.CONSTRAINT_NAME AND c.TABLE_NAME=tableName AND c.CONSTRAINT_TYPE=constraintType AND cc.COLUMN_NAME=columnName;
     EXECUTE IMMEDIATE 'ALTER TABLE ' || tableName || ' DROP CONSTRAINT ' || temp;
END dropConstraintByName;
/

CREATE OR REPLACE PROCEDURE dropConstraintByType (tableName IN VARCHAR2, constraintType IN VARCHAR2) IS
     temp VARCHAR2(30);
BEGIN
     SELECT c.CONSTRAINT_NAME INTO temp FROM USER_CONSTRAINTS c WHERE c.TABLE_NAME=tableName AND c.CONSTRAINT_TYPE=constraintType;
     EXECUTE IMMEDIATE 'ALTER TABLE ' || tableName || ' DROP CONSTRAINT ' || temp;
END dropConstraintByType;
/

--
-- Sequences
--

CREATE SEQUENCE ADAPTER_SYNC_DATA_SEQ START WITH 1 CACHE 50;
CREATE SEQUENCE APP_SYNC_DATA_SEQ START WITH 1 CACHE 50;

--
-- ADAPTER_SYNC_DATA
--

CREATE TABLE ADAPTER_SYNC_DATA (ID NUMBER(19,0) NOT NULL, deployable BLOB NOT NULL, deployableHash VARCHAR2(255) NOT NULL, deployableKey VARCHAR2(255) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_deployableKey UNIQUE (deployableKey) DEFERRABLE);

--
-- APP_SYNC_DATA
--

CREATE TABLE APP_SYNC_DATA (ID NUMBER(19,0) NOT NULL, appDeployableKey VARCHAR2(255) NOT NULL, deployable BLOB NOT NULL, deployableHash VARCHAR2(255) NOT NULL, lastPersistentPropertyChange NUMBER(19,0) NOT NULL, PRIMARY KEY (ID), CONSTRAINT UNQ_appDeployableKey UNIQUE (appDeployableKey) DEFERRABLE);

--
-- APP_VERSION_ACCESS_DATA
--

-- Rename ENVIRONMENT column, remove old NOT NULL constraint and add new one.

EXECUTE dropConstraintByName('APP_VERSION_ACCESS_DATA', 'ENVIRONMENT', 'C');
ALTER TABLE APP_VERSION_ACCESS_DATA RENAME COLUMN ENVIRONMENT TO ENV;
ALTER TABLE APP_VERSION_ACCESS_DATA ADD CONSTRAINT WL_AVAD_ENV CHECK (ENV IS NOT NULL);

-- Remove (GADGET_NAME,ENVIRONMENT,VERSION) unique constraint and create a
-- replacement.

EXECUTE dropConstraintByType('APP_VERSION_ACCESS_DATA', 'U');
ALTER TABLE APP_VERSION_ACCESS_DATA ADD CONSTRAINT UNQ_GADGET_NAMENVVERSION UNIQUE (GADGET_NAME, ENV, VERSION);

--
-- AUTH_ASSOCIATED_IDENTITY
--

-- Change IDENTITYSTR from LONG to CLOB.

ALTER TABLE AUTH_ASSOCIATED_IDENTITY MODIFY TOIDENTITYSTR CLOB;

--
-- CLUSTER_SYNC
--

--
-- GADGET_APPLICATIONS
--

DROP TABLE GADGET_APPLICATIONS;

CREATE TABLE GADGET_APPLICATIONS (ID NUMBER(19,0) NOT NULL, ENFORCE_AUTHENTICITY NUMBER, ENVIRONMENT_ID VARCHAR2(255) NOT NULL, SERVER_VERSION VARCHAR2(255) NOT NULL, VERSION VARCHAR2(255) NOT NULL, VERSION_LOCKED NUMBER, GADGET_ID NUMBER(19,0) NOT NULL, PRIMARY KEY (ID));

CREATE INDEX I_GDGTTNS_GADGET ON GADGET_APPLICATIONS (GADGET_ID);

--
-- GADGET_USER
--

-- Add GADGET_APP_ID and GADGET_ID.

ALTER TABLE GADGET_USER ADD GADGET_APP_ID VARCHAR2(255) NOT NULL;
ALTER TABLE GADGET_USER ADD GADGET_ID VARCHAR2(255) NOT NULL;

-- Remove (USER_ID,GADGET_INSTANCE_ID) unique constraint and add a replacement.

EXECUTE dropConstraintByType('GADGET_USER', 'P');
ALTER TABLE GADGET_USER ADD CONSTRAINT WL_GU_PK PRIMARY KEY (GADGET_APP_ID, USER_ID);

-- Drop GADGET_INSTANCE_ID.

ALTER TABLE GADGET_USER DROP COLUMN GADGET_INSTANCE_ID;

--
-- GADGET_USER_PREF
--

-- Change VALUE from LONG to CLOB.

ALTER TABLE GADGET_USER_PREF MODIFY VALUE CLOB;

-- Drop GADGET_INSTANCE_ID.

ALTER TABLE GADGET_USER_PREF DROP COLUMN GADGET_INSTANCE_ID;

-- Add GADGET_APP_ID.

ALTER TABLE GADGET_USER_PREF ADD GADGET_APP_ID VARCHAR2(255) NOT NULL;

--
-- GADGETS
--

-- Remove (NAME) unique constraint and add a replacement.

EXECUTE dropConstraintByType ('GADGETS', 'U');
ALTER TABLE GADGETS ADD CONSTRAINT UNQ_ UNIQUE (NAME);

--
-- NOTIFICATION_APPLICATION
--

-- Add MEDIATORTYPE and ENABLED.

ALTER TABLE NOTIFICATION_APPLICATION ADD MEDIATORTYPE NUMBER (38, 0) NOT NULL;
ALTER TABLE NOTIFICATION_APPLICATION ADD ENABLED NUMBER (38, 0) NOT NULL;

-- Remove (APPLICATIONID,PLATFORMSTR) unique constraint and add a replacement.

EXECUTE dropConstraintByType ('NOTIFICATION_APPLICATION', 'P');
ALTER TABLE NOTIFICATION_APPLICATION ADD CONSTRAINT WL_NA_PK PRIMARY KEY (APPLICATIONID, MEDIATORTYPE, PLATFORMSTR);

-- Change DATASTR from LONG to CLOB.

ALTER TABLE NOTIFICATION_APPLICATION MODIFY DATASTR CLOB;

--
-- NOTIFICATION_DEVICE
--

-- Drop DEVICE_IDX and TOKEN_IDX.

DROP INDEX DEVICE_IDX;
DROP INDEX TOKEN_IDX;

-- Drop foreign key.

EXECUTE dropConstraintByType ('NOTIFICATION_DEVICE', 'R');

-- Add new index.

CREATE INDEX I_NTFCDVC_PARENT ON NOTIFICATION_DEVICE (USERSUBSCRIPTIONID);

--
-- NOTIFICATION_MEDIATOR
--

-- Change STATESTR from LONG to CLOB.

ALTER TABLE NOTIFICATION_MEDIATOR MODIFY STATESTR CLOB;

--
-- NOTIFICATION_USER
--

-- Remove (USERID,EVENTSOURCE) unique constraint and rename it.

EXECUTE dropConstraintByType ('NOTIFICATION_USER', 'U');
ALTER TABLE NOTIFICATION_USER ADD CONSTRAINT UNQ_USERIDEVENTSOURCE UNIQUE (USERID, EVENTSOURCE);

-- Change STATE from LONG to CLOB.

ALTER TABLE NOTIFICATION_USER MODIFY STATE CLOB;

--
-- OPENJPA_SEQUENCE_TABLE
--

CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID NUMBER NOT NULL, SEQUENCE_VALUE NUMBER(19,0), PRIMARY KEY (ID));

--
-- PROPERTIES
--

--
-- USAGE_DATA
--

--
-- WORKLIGHT_VERSION
--

CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL);
INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM DUAL WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);

