/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
final def props = apTool.getStepProperties();

def serverpath = props['serverpath']
def context = props['context']
def user = props['user']
def password = props['password']
boolean disableSSL = Boolean.parseBoolean(props['disableSSL'])
def application = props['package']
def os = props['os']
def version = props['version']
def appCenterJar = props['appCenterJar']
def json4jJar = props['json4jJar']

try {
    println "Deleting the application with the following properties:"
    println "Server Path: ${serverpath}"
    println "Context: ${context}"
    println "Disable SSL: ${disableSSL}"
    println "Application Package: ${application}"
    println "Operating System: ${os}"
    println "Version: ${version}"
    println "Application Center Deploy Tool JAR: ${appCenterJar}"
    println "JSON4J JAR: ${json4jJar}"
    println ""

    if(serverpath == null || context == null || serverpath.trim().length() == 0 || context.trim().length() == 0) {
        println "Error: You must specify both the server path and the server context."
        System.exit(1)
    }

    if(context.charAt(0) != '/' && !serverpath.endsWith("/")) {
        context = "/" + context
    }

    if(os == "all")
        os = ""

    File appCenterJarFile = new File(appCenterJar)
    if(!appCenterJarFile.exists() || !appCenterJarFile.isFile()) {
        println "Error: The path to the Application Center Deploy Tool Ant JAR file is invalid: " +
            "${appCenterJarFile.getCanonicalPath()}. Change the value of the Application " +
            "Center Ant JAR File Path attribute to the path to the Application Center Ant " +
            "JAR file. For example, use " +
            "/opt/IBM/Worklight/ApplicationCenter/tools/applicationcenterdeploytool.jar."
        System.exit(1)
    }

    File json4jJarFile = new File(json4jJar)
    if(!json4jJarFile.exists() || !json4jJarFile.isFile()) {
        println "Error: The path to the JSON4J JAR file is invalid: " +
            "${json4jJarFile.getCanonicalPath()}. Change the value of the JSON4J JAR File " +
            "Path attribute to the path to the JSON4J JAR file. For example, use " +
            "/opt/IBM/Worklight/ApplicationCenter/tools/json4j.jar."
        System.exit(1)
    }

    def taskdefClasspath = appCenterJarFile.absolutePath + ":" + json4jJarFile.absolutePath
    def ant = new AntBuilder();
    try {
        ant.taskdef ( name: "deleteApp", classname:"com.ibm.appcenter.ant.DeleteApps", classpath: taskdefClasspath )
    } catch (Exception e) {
        println "Error: The class com.ibm.appcenter.ant.DeleteApps is not found in " +
            "the specified Application Center Deploy Tool Ant JAR file: " +
            "${appCenterJarFile.getCanonicalPath()}."
        println "Explanation: This error occurs if the JAR file specified in the " +
            "Worklight Ant JAR File Path attribute is not correct."
        println "User response: Change the value of the Application Center Deploy " +
            "Tool Ant JAR File Path attribute to the path to the Application " +
            "Center Deploy Tool Ant JAR file. For example, use " +
            "/opt/IBM/Worklight/ApplicationCenter/tools/applicationcenterdeploytool.jar. " +
            "Also, confirm that the path to the JSON4J JAR file value is " +
            "correctly specified in the JSON4J JAR File Path attribute: " +
            "${json4jJarFile.getCanonicalPath()}. For example, use " +
            "/opt/IBM/Worklight/ApplicationCenter/tools/json4j.jar."
        System.exit(1)
    }
    ant.deleteApp ( serverPath:serverpath, context:context, loginUser:user, loginPass:password,
        disableSSLSecurity:disableSSL, application:application, os:os, version:version )
} catch (Exception e) {
    println "An error occurred while deleting the application: ${e.message}"
    System.exit(1)
}

println "The Remove Application from Application Center step completed successfully."
