--
-- Licensed Materials - Property of IBM
-- 5725-G92 (C) Copyright IBM Corp. 2011, 2013. All Rights Reserved.
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
--

SELECT SEQUENCE_OWNER AS SEQUENCE_SCHEMA, SEQUENCE_NAME FROM ALL_SEQUENCES;
CREATE TABLE ACTIVITIES_CUBE (AID NUMBER(19,0) NOT NULL, ACTIVITY_DATE DATE, APP_NAME VARCHAR2(255), APP_VERSION VARCHAR2(255), DEVICE_ID VARCHAR2(255), ENVIRONMENT VARCHAR2(255), TOTAL_ACTIVITY NUMBER(19,0), PRIMARY KEY (AID));
CREATE TABLE APP_ACTIVITY_REPORT (ID NUMBER(19,0) NOT NULL, ACTIVITY VARCHAR2(4000), ACTIVITY_TIMESTAMP TIMESTAMP, ADAPTER VARCHAR2(255), DEVICE_ID VARCHAR2(255), DEVICE_MODEL VARCHAR2(255), DEVICE_OS VARCHAR2(255), ENVIRONMENT VARCHAR2(255), GADGET_NAME VARCHAR2(255), GADGET_VERSION VARCHAR2(255), IP_ADDRESS VARCHAR2(255), PROC VARCHAR2(255), SESSION_ID VARCHAR2(255), SOURCE VARCHAR2(255), USER_AGENT VARCHAR2(255), LONGITUDE BINARY_DOUBLE, LATITUDE BINARY_DOUBLE, POS_USER_TIME TIMESTAMP(3), WIFI_APS VARCHAR2(4000), WIFI_CONNECTED_SSID VARCHAR(32), WIFI_CONNECTED_MAC CHAR(20), WIFI_USER_TIME TIMESTAMP(3), APP_CONTEXT VARCHAR2(4000), PRIMARY KEY (ID));
CREATE TABLE FACT_ACTIVITIES (AID VARCHAR2(255) NOT NULL, ACTIVITY_DATE DATE, APP_NAME VARCHAR2(255), APP_VERSION VARCHAR2(255), DEVICE_ID VARCHAR2(255), DEVICE_MODEL VARCHAR2(255), DEVICE_OS VARCHAR2(255), ENVIRONMENT VARCHAR2(255), TOTAL_ACTIVITY NUMBER(10,0), PRIMARY KEY (AID));
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID NUMBER NOT NULL, SEQUENCE_VALUE NUMBER(19,0), PRIMARY KEY (ID));
CREATE TABLE PROC_REPORT (ID NUMBER(10,0) NOT NULL, NUM_PROCESSED NUMBER(10,0), PROC_TIMESTAMP TIMESTAMP, PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_REPORT (ID NUMBER(19,0) NOT NULL, APP_NAME VARCHAR2(255), DESTINATION_NUMBER VARCHAR2(255), EVENT_SOURCE VARCHAR2(255), MEDIATOR VARCHAR2(255), MESSAGE_COUNT NUMBER(10,0), NOTIFICATION_TIMESTAMP TIMESTAMP, SENDER_ID VARCHAR2(255), SUBSCRIPTION_PROPERTIES VARCHAR2(255), PRIMARY KEY (ID));
CREATE TABLE NOTIFICATION_ACTIVITIES (SID VARCHAR2(255) NOT NULL, EVENT_SOURCE VARCHAR2(255), MEDIATOR VARCHAR2(255), NOTIFICATION_DATE DATE, TOTAL_NOTIFICATIONS NUMBER(10,0), PRIMARY KEY (SID));
CREATE TABLE NOTIFICATION_PROC_REPORT (ID NUMBER(10,0) NOT NULL, NUM_PROCESSED NUMBER(10,0), PROC_TIMESTAMP TIMESTAMP, PRIMARY KEY (ID));
CREATE TABLE WORKLIGHT_VERSION (WORKLIGHT_VERSION VARCHAR(50) NOT NULL);
INSERT INTO WORKLIGHT_VERSION(WORKLIGHT_VERSION) SELECT '0.0.0.initial' FROM DUAL WHERE NOT EXISTS (SELECT * FROM WORKLIGHT_VERSION);
