/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appcenter.ant;

import com.ibm.appcenter.ant.PublishException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ImpRestServices {
    static final String NOT_SET = "@@unset@@";
    private static final String DEFAULT_SERVER_ROOT = "http://localhost:8080";
    private static final String DEFAULT_CONTEXT = "/applicationcenter";
    private static final String DEFAULT_LOGIN = "appcenteradmin";
    private static final String DEFAULT_PASSWORD = "admin";
    private static final String DEFAULT_DESCRIPTION = "@@unset@@";
    private static final String DEFAULT_LABEL = "@@unset@@";
    private static final String DEFAULT_IS_INSTALLER = "@@unset@@";
    private static final String DEFAULT_IS_RECOMMENDED = "@@unset@@";
    private static final String DEFAULT_IS_ACTIVE = "@@unset@@";
    private static final String DEFAULT_IS_READY_FOR_PRODUCTION = "@@unset@@";
    private String serverRoot = "http://localhost:8080";
    private String loginPass = "appcenteradmin";
    private String loginUser = "admin";
    private String context = "/applicationcenter";
    private String description = "@@unset@@";
    private String fallbackLabel = "@@unset@@";
    private String isInstaller = "@@unset@@";
    private String isRecommended = "@@unset@@";
    private String isActive = "@@unset@@";
    private String isReadyProd = "@@unset@@";
    private boolean forceOverwrite = true;
    private boolean exceptionOnNotFoundOnDelete = true;
    static String[] os = new String[]{"Android", "iOS", "BlackBerry"};
    static String[] container = new String[]{"apk", "ipa", "zip"};
    private ResourceBundle bundle = ResourceBundle.getBundle("com.ibm.appcenter.upload", Locale.getDefault());
    private final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    private String getServerRoot() {
        return this.serverRoot;
    }

    public void setServerRoot(String root) {
        this.serverRoot = root;
    }

    private String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    private String getAuthentication() {
        return this.loginUser + ":" + this.loginPass;
    }

    public void setAuthentication(String user, String pass) {
        this.loginUser = user;
        this.loginPass = pass;
    }

    public void setDescription(String descr) {
        if (descr == null) {
            descr = "";
        }
        this.description = descr;
    }

    private String getDescription(String label) {
        if ("@@unset@@".equals(this.description)) {
            return "This is application " + label + ".";
        }
        return this.description;
    }

    public void setFallbackLabel(String label) {
        if (label == null) {
            label = "";
        }
        this.fallbackLabel = label;
    }

    private String getFallbackLabel(String pkg) {
        if ("@@unset@@".equals(this.fallbackLabel)) {
            return pkg;
        }
        return this.fallbackLabel;
    }

    public void setIsInstaller(String set) {
        this.isInstaller = set;
    }

    public void setIsRecommended(String set) {
        this.isRecommended = set;
    }

    public void setIsActive(String set) {
        this.isActive = set;
    }

    public void setIsReadyForProduction(String set) {
        this.isReadyProd = set;
    }

    private String getFlag(String variable, String defaultValue) {
        if ("true".equalsIgnoreCase(variable)) {
            return "Y";
        }
        if ("false".equalsIgnoreCase(variable)) {
            return "N";
        }
        if ("Y".equalsIgnoreCase(variable)) {
            return "Y";
        }
        if ("N".equalsIgnoreCase(variable)) {
            return "N";
        }
        return defaultValue;
    }

    public void setForceOverwrite(boolean force) {
        this.forceOverwrite = force;
    }

    public void setExceptionOnNotFoundOnDelete(boolean silent) {
        this.exceptionOnNotFoundOnDelete = silent;
    }

    public void setDisableSSLSecurity(boolean flag) {
        if (flag) {
            try {
                System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", "true");
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession sslSession) {
                        return true;
                    }
                });
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
            }
            catch (Exception ex) {
                String msg = this.getString("ImpRestServices.exceptionWhenDisableSSL", ex.getMessage());
                PublishException e = new PublishException(msg, ex, 4);
                throw e;
            }
        }
    }

    private void doLogin(HttpURLConnection connection) {
        connection.setDoOutput(true);
        connection.setRequestProperty("Authorization", "Basic " + this.base64encode(this.getAuthentication().getBytes(), -1));
    }

    public void publish(File selectedFile) throws PublishException {
        this.publish(selectedFile, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private JSONObject publish(File selectedFile, boolean silentAboutPublish) throws PublishException {
        if (selectedFile == null) {
            return null;
        }
        JSONObject obj = this.uploadRequest(selectedFile, "POST");
        if (obj == null) {
            return null;
        }
        JSONObject req = new JSONObject();
        String pkgName = (String)obj.get((Object)"pkg");
        String version = (String)obj.get((Object)"version");
        String versionName = (String)obj.get((Object)"versionName");
        String vendor = (String)obj.get((Object)"vendor");
        String label = (String)obj.get((Object)"label");
        String osString = (String)obj.get((Object)"os");
        String filename = selectedFile.toString();
        String fileExtension = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
        String shortname = filename.substring(filename.lastIndexOf(File.separatorChar) + 1, filename.length());
        if (osString == null || osString.length() == 0) {
            boolean found = false;
            for (int i = 0; i < container.length; ++i) {
                if (!fileExtension.equals(container[i])) continue;
                osString = os[i];
                found = true;
            }
            if (!found) {
                osString = "HTML5";
            }
        }
        req.put((Object)"pkg", (Object)pkgName);
        req.put((Object)"os", (Object)osString);
        req.put((Object)"version", (Object)version);
        if (versionName != null) {
            req.put((Object)"versionName", (Object)versionName);
        }
        if (vendor != null) {
            req.put((Object)"vendor", (Object)vendor);
        }
        if (label == null) {
            label = this.getFallbackLabel(pkgName);
        }
        req.put((Object)"label", (Object)label);
        req.put((Object)"description", (Object)this.getDescription(label));
        JSONObject file = new JSONObject();
        file.put((Object)"cid", obj.get((Object)"cid"));
        file.put((Object)"type", (Object)fileExtension);
        file.put((Object)"size", obj.get((Object)"size"));
        file.put((Object)"filename", (Object)shortname);
        JSONArray files = new JSONArray();
        files.add((Object)file);
        req.put((Object)"files", (Object)files);
        req.put((Object)"mandatory", (Object)this.getFlag(this.isRecommended, "N"));
        req.put((Object)"is_installer", (Object)this.getFlag(this.isInstaller, "N"));
        req.put((Object)"is_ready_prod", (Object)this.getFlag(this.isReadyProd, "N"));
        req.put((Object)"is_active", (Object)this.getFlag(this.isActive, "Y"));
        JSONObject appDesc = this.applicationRequest(req, "POST");
        if (appDesc != null) {
            if (silentAboutPublish) return req;
            System.err.println(this.getString("ImpRestServices.publish", appDesc.toString()));
            return req;
        }
        if (!this.forceOverwrite) {
            String msg = this.getString("ImpRestServices.failed", pkgName, version, osString);
            PublishException e = new PublishException(msg, 1);
            throw e;
        }
        appDesc = this.applicationRequest(req, "PUT");
        if (appDesc != null) {
            if (silentAboutPublish) return req;
            System.err.println(this.getString("ImpRestServices.update", appDesc));
            return req;
        }
        String msg = this.getString("ImpRestServices.failed", pkgName, version, osString);
        PublishException e = new PublishException(msg, 1);
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(File selectedFile) throws PublishException {
        boolean oldForceOverwrite = this.forceOverwrite;
        try {
            this.forceOverwrite = true;
            JSONObject app = this.publish(selectedFile, true);
            if (app != null) {
                System.err.println(this.getString("ImpRestServices.delete", app.toString()));
                this.appDeleteRequest(app, false, false);
            }
        }
        finally {
            this.forceOverwrite = oldForceOverwrite;
        }
    }

    public void delete(String pkg, String os, String version) throws PublishException {
        if (os == null || os.length() == 0) {
            this.deleteForAllOs(pkg, version);
            return;
        }
        JSONObject obj = new JSONObject();
        obj.put((Object)"pkg", (Object)pkg);
        obj.put((Object)"os", (Object)os);
        obj.put((Object)"version", (Object)version);
        System.err.println(this.getString("ImpRestServices.delete", obj.toString()));
        obj = this.appDeleteRequest(obj, false, true);
        if (obj != null && "false".equals(obj.get((Object)"found"))) {
            String msg = this.getString("ImpRestServices.appNotFound3", pkg, version, os);
            if (this.exceptionOnNotFoundOnDelete) {
                System.err.println(msg);
            } else {
                throw new PublishException(msg);
            }
        }
    }

    public void delete(String pkg, String os) throws PublishException {
        JSONObject obj = new JSONObject();
        obj.put((Object)"pkg", (Object)pkg);
        obj.put((Object)"os", (Object)os);
        System.err.println(this.getString("ImpRestServices.delete", obj.toString()));
        obj = this.appDeleteRequest(obj, true, true);
        if (obj != null && "false".equals(obj.get((Object)"found"))) {
            String msg = this.getString("ImpRestServices.appNotFound2", pkg, os);
            if (this.exceptionOnNotFoundOnDelete) {
                System.err.println(msg);
            } else {
                throw new PublishException(msg);
            }
        }
    }

    public void delete(String pkg) throws PublishException {
        this.deleteForAllOs(pkg, null);
    }

    public void deleteForAllOs(String pkg, String version) throws PublishException {
        boolean allVersions = true;
        JSONObject obj = new JSONObject();
        obj.put((Object)"pkg", (Object)pkg);
        if (version != null) {
            obj.put((Object)"version", (Object)version);
            allVersions = false;
        }
        boolean found = false;
        JSONObject[] result = new JSONObject[os.length];
        for (int i = 0; i < os.length; ++i) {
            obj.put((Object)"os", (Object)os[i]);
            obj.remove((Object)"found");
            System.err.println(this.getString("ImpRestServices.delete", obj.toString()));
            result[i] = this.appDeleteRequest(obj, allVersions, true);
            if (result[i] == null || "false".equals(result[i].get((Object)"found"))) continue;
            found = true;
        }
        if (!found) {
            String msg = allVersions ? this.getString("ImpRestServices.appNotFound1", pkg) : this.getString("ImpRestServices.appNotFound4", pkg, version);
            if (this.exceptionOnNotFoundOnDelete) {
                System.err.println(msg);
            } else {
                throw new PublishException(msg);
            }
        }
    }

    private void writeFile(String name, String filePath, DataOutputStream out, String boundary) throws PublishException {
        try {
            int amountRead;
            out.writeBytes("content-disposition: form-data; name=\"" + name + "\"; filename=\"" + filePath + "\"\r\n");
            out.writeBytes("content-type: application/octet-stream\r\n\r\n");
            FileInputStream fis = new FileInputStream(filePath);
            byte[] buffer = new byte[1024];
            while ((amountRead = fis.read(buffer)) != -1) {
                out.write(buffer, 0, amountRead);
            }
            fis.close();
            out.writeBytes("\r\n--" + boundary + "\r\n");
        }
        catch (Exception e) {
            String msg = this.getString("ImpRestServices.exceptionWhenTransfer", e.getMessage());
            throw new PublishException(msg, e, 2);
        }
    }

    private JSONObject uploadRequest(File file, String httpMethod) throws PublishException {
        String inContent = null;
        String filename = file.toString();
        String fileExtension = filename.substring(filename.lastIndexOf(46) + 1);
        String serviceURL = this.getServerRoot() + this.getContext() + "/service/desktop/upload/filetype/" + fileExtension.toLowerCase();
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(serviceURL).openConnection();
            connection.setRequestMethod(httpMethod);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            String boundary = "-----------------------------7dc3462f122490";
            this.doLogin(connection);
            connection.setRequestProperty("Content-type", "multipart/form-data; boundary=" + boundary);
            connection.setRequestProperty("Accept", "application/json");
            DataOutputStream outStream = new DataOutputStream(connection.getOutputStream());
            outStream.writeBytes("--" + boundary + "\r\n");
            this.writeFile("file", file.getAbsolutePath(), outStream, boundary);
            outStream.flush();
            outStream.close();
            InputStream inStream = connection.getInputStream();
            inContent = new Scanner(inStream).useDelimiter("\\A").next();
            inStream.close();
        }
        catch (ConnectException e) {
            String msg = this.getString("ImpRestServices.exceptionWhenUploadConnectException", e.getMessage(), filename);
            throw new PublishException(msg, e, 3);
        }
        catch (FileNotFoundException e) {
            String emsg = e.getMessage();
            String msg = emsg != null && (emsg.startsWith("http:") || emsg.startsWith("https:")) ? this.getString("ImpRestServices.exceptionWhenUploadWrongURI", e.getMessage(), filename) : this.getString("ImpRestServices.exceptionWhenUploadGeneralException", e.getMessage(), filename);
            throw new PublishException(msg, e, 3);
        }
        catch (SSLHandshakeException e) {
            String msg = this.getString("ImpRestServices.exceptionWhenSSL", e.getMessage());
            throw new PublishException(msg, e, 3);
        }
        catch (IOException e) {
            String emsg = e.getMessage();
            String msg = emsg != null && (emsg.contains(" 401 ") || emsg.contains(" 403 ")) ? this.getString("ImpRestServices.exceptionWhenUpload401", e.getMessage(), filename) : (emsg != null && (emsg.contains(" 400 ") || emsg.contains(" 404 ") || emsg.contains(" 405 ") || emsg.contains(" 406 ")) ? this.getString("ImpRestServices.exceptionWhenUpload400", e.getMessage(), filename) : (emsg != null && (emsg.contains(" 408 ") || emsg.contains(" 504 ")) ? this.getString("ImpRestServices.exceptionWhenUpload408", e.getMessage(), filename) : (emsg != null && emsg.contains(" 500 ") ? this.getString("ImpRestServices.exceptionWhenUpload500", e.getMessage(), filename) : this.getString("ImpRestServices.exceptionWhenUploadGeneralException", e.getMessage(), filename))));
            throw new PublishException(msg, e, 3);
        }
        catch (Exception e) {
            String msg = this.getString("ImpRestServices.exceptionWhenUploadGeneralException", e.getMessage(), filename);
            throw new PublishException(msg, e, 3);
        }
        try {
            return (JSONObject)JSONArray.parse((String)inContent).get(0);
        }
        catch (Exception e) {
            String msg = this.getString("ImpRestServices.exceptionWhenUpload", e.getMessage(), filename, inContent);
            throw new PublishException(msg, e, 3);
        }
    }

    private JSONObject applicationRequest(JSONObject appObject, String httpMethod) throws PublishException {
        String serviceURL = this.getServerRoot() + this.getContext() + "/service/desktop/application";
        if (httpMethod.equals("PUT")) {
            String pkg = (String)appObject.get((Object)"pkg");
            String version = (String)appObject.get((Object)"version");
            String os = (String)appObject.get((Object)"os");
            serviceURL = serviceURL + "/" + this.encodeURIComponent(pkg);
            JSONObject existingApp = this.appInfoRequest(os, pkg, version);
            appObject = this.merge(appObject, existingApp);
        }
        try {
            int responseCode;
            HttpURLConnection connection = (HttpURLConnection)new URL(serviceURL).openConnection();
            connection.setRequestMethod(httpMethod);
            if (appObject != null) {
                connection.setDoOutput(true);
            }
            connection.setDoInput(true);
            connection.setUseCaches(false);
            this.doLogin(connection);
            connection.setRequestProperty("Content-type", "application/json");
            if (appObject != null) {
                DataOutputStream outStream = new DataOutputStream(connection.getOutputStream());
                outStream.writeBytes(appObject.toString());
                outStream.flush();
                outStream.close();
            }
            if ((responseCode = connection.getResponseCode()) == 409) {
                return null;
            }
            InputStream inStream = connection.getInputStream();
            String inContent = new Scanner(inStream).useDelimiter("\\A").next();
            return (JSONObject)JSONArray.parse((String)inContent).get(0);
        }
        catch (Exception e) {
            String msg = this.getString("ImpRestServices.exceptionWhenRequest", e.getMessage());
            throw new PublishException(msg, e, 4);
        }
    }

    private JSONObject appDeleteRequest(JSONObject appObject, boolean allVersions, boolean silentOnFileNotFound) throws PublishException {
        String serviceURL = this.getServerRoot() + this.getContext() + "/service/desktop/application";
        String pkg = (String)appObject.get((Object)"pkg");
        String version = (String)appObject.get((Object)"version");
        String os = (String)appObject.get((Object)"os");
        serviceURL = serviceURL + "/" + this.encodeURIComponent(os);
        serviceURL = serviceURL + "/" + this.encodeURIComponent(pkg);
        serviceURL = allVersions ? serviceURL + "?version=all" : serviceURL + "/" + this.encodeURIComponent(version);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(serviceURL).openConnection();
            connection.setRequestMethod("DELETE");
            connection.setDoOutput(false);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            this.doLogin(connection);
            connection.setRequestProperty("Content-type", "application/json");
            int responseCode = connection.getResponseCode();
            if (responseCode == 409) {
                return null;
            }
            InputStream inStream = connection.getInputStream();
            String inContent = new Scanner(inStream).useDelimiter("\\A").next();
            return JSONObject.parse((String)inContent);
        }
        catch (FileNotFoundException e1) {
            if (silentOnFileNotFound) {
                appObject.put((Object)"found", (Object)"false");
                return appObject;
            }
            String msg = this.getString("ImpRestServices.exceptionWhenRequest", e1.getMessage());
            throw new PublishException(msg, e1, 4);
        }
        catch (SSLHandshakeException e) {
            String msg = this.getString("ImpRestServices.exceptionWhenSSL", e.getMessage());
            throw new PublishException(msg, e, 4);
        }
        catch (IOException e) {
            String emsg = e.getMessage();
            String msg = emsg != null && (emsg.contains(" 401 ") || emsg.contains(" 403 ")) ? this.getString("ImpRestServices.exceptionWhenRequest401", e.getMessage()) : (emsg != null && (emsg.contains(" 400 ") || emsg.contains(" 404 ") || emsg.contains(" 405 ") || emsg.contains(" 406 ")) ? this.getString("ImpRestServices.exceptionWhenRequest400", e.getMessage()) : (emsg != null && (emsg.contains(" 408 ") || emsg.contains(" 504 ")) ? this.getString("ImpRestServices.exceptionWhenRequest408", e.getMessage()) : (emsg != null && emsg.contains(" 500 ") ? this.getString("ImpRestServices.exceptionWhenRequest500", e.getMessage()) : this.getString("ImpRestServices.exceptionWhenRequest", e.getMessage()))));
            throw new PublishException(msg, e, 4);
        }
        catch (Exception e) {
            String msg = this.getString("ImpRestServices.exceptionWhenRequest", e.getMessage());
            throw new PublishException(msg, e, 4);
        }
    }

    private JSONObject merge(JSONObject newApp, JSONObject existingApp) {
        String readyProd;
        String installer;
        String mandatory;
        String label;
        if (existingApp == null) {
            return newApp;
        }
        String descr = (String)existingApp.get((Object)"description");
        if (descr != null && "@@unset@@".equals(this.description)) {
            newApp.put((Object)"description", (Object)descr);
        }
        if ((label = (String)existingApp.get((Object)"label")) != null && "@@unset@@".equals(this.fallbackLabel)) {
            newApp.put((Object)"label", (Object)label);
        }
        if ((mandatory = (String)existingApp.get((Object)"mandatory")) != null && "@@unset@@".equals(this.isRecommended)) {
            newApp.put((Object)"mandatory", (Object)mandatory);
        }
        if ((installer = (String)existingApp.get((Object)"is_installer")) != null && "@@unset@@".equals(this.isInstaller)) {
            newApp.put((Object)"is_installer", (Object)installer);
        }
        if ((readyProd = (String)existingApp.get((Object)"is_ready_prod")) != null && "@@unset@@".equals(this.isReadyProd)) {
            newApp.put((Object)"is_ready_prod", (Object)readyProd);
        }
        return newApp;
    }

    private JSONObject appInfoRequest(String os, String pkg, String version) throws PublishException {
        String serviceURL = this.getServerRoot() + this.getContext() + "/service/directory/" + this.encodeURIComponent(os) + "/" + this.encodeURIComponent(pkg) + "/" + this.encodeURIComponent(version) + "?activeOnly=false";
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(serviceURL).openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            this.doLogin(connection);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                InputStream inStream = connection.getInputStream();
                String inContent = new Scanner(inStream).useDelimiter("\\A").next();
                return JSONObject.parse((String)inContent);
            }
            return null;
        }
        catch (Exception e) {
            String msg = this.getString("ImpRestServices.exceptionWhenGetInfo", e.getMessage());
            throw new PublishException(msg, e, 5);
        }
    }

    private String encodeURIComponent(String s) {
        byte[] bytes;
        if (s == null) {
            return s;
        }
        StringBuffer buf = new StringBuffer();
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = s.getBytes();
        }
        for (int i = 0; i < bytes.length; ++i) {
            char b = (char)bytes[i];
            if (b == ' ') {
                buf.append("%20");
                continue;
            }
            if (b == '/') {
                buf.append("%252F");
                continue;
            }
            if (b == '\\') {
                buf.append("%255C");
                continue;
            }
            if (b == ';') {
                buf.append("%253B");
                continue;
            }
            if (b == '#') {
                buf.append("%2523");
                continue;
            }
            if (b == '?') {
                buf.append("%253F");
                continue;
            }
            if (ImpRestServices.isUnreserved(b)) {
                buf.append(b);
                continue;
            }
            buf.append('%');
            buf.append(Integer.toHexString(b).toUpperCase());
        }
        return buf.toString();
    }

    private static boolean isUnreserved(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c) || ".-~_".indexOf(c) >= 0;
    }

    private void encode(byte[] in, byte[] out) {
        int numpadding;
        int quantum;
        if (in.length == 3) {
            quantum = (in[0] & 0xFF) << 16 | (in[1] & 0xFF) << 8 | in[2] & 0xFF;
            numpadding = 0;
        } else if (in.length == 2) {
            quantum = (in[0] & 0xFF) << 16 | (in[1] & 0xFF) << 8;
            numpadding = 1;
        } else {
            quantum = (in[0] & 0xFF) << 16;
            numpadding = 2;
        }
        int idx = (quantum & 0xFC0000) >> 18;
        out[0] = (byte)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(idx);
        idx = (quantum & 0x3F000) >> 12;
        out[1] = (byte)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(idx);
        idx = (quantum & 0xFC0) >> 6;
        out[2] = (byte)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(idx);
        idx = quantum & 0x3F;
        out[3] = (byte)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(idx);
        if (numpadding > 0) {
            out[3] = 61;
        }
        if (numpadding > 1) {
            out[2] = 61;
        }
    }

    public String base64encode(byte[] buffer, int maxBytesPerLine) {
        StringBuffer result = new StringBuffer();
        byte[] in = new byte[3];
        byte[] out = new byte[4];
        int linelen = 0;
        int idx = 0;
        while (idx < buffer.length) {
            if (idx == buffer.length - 1) {
                in = new byte[]{buffer[idx++]};
            } else if (idx == buffer.length - 2) {
                in = new byte[]{buffer[idx++], buffer[idx++]};
            } else {
                in[0] = buffer[idx++];
                in[1] = buffer[idx++];
                in[2] = buffer[idx++];
            }
            this.encode(in, out);
            for (int i = 0; i < 4; ++i) {
                result.append((char)out[i]);
            }
            if (maxBytesPerLine <= 0 || (linelen += 4) < maxBytesPerLine) continue;
            result.append("\n");
            linelen = 0;
        }
        return result.toString();
    }

    private String getString(String key, Object arg) {
        return MessageFormat.format(this.bundle.getString(key), arg);
    }

    private String getString(String key, Object arg1, Object arg2) {
        return MessageFormat.format(this.bundle.getString(key), arg1, arg2);
    }

    private String getString(String key, Object arg1, Object arg2, Object arg3) {
        return MessageFormat.format(this.bundle.getString(key), arg1, arg2, arg3);
    }
}

