/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appcenter.ant;

import com.ibm.appcenter.ant.ImpRestServices;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class DeleteApps
extends Task {
    protected File file = null;
    protected Vector<FileSet> filesets = new Vector();
    private String appToBeDeleted = "";
    private String appOsToBeDeleted = "";
    private String appVersionToBeDeleted = "";
    private String serverPath = "";
    private String loginUser = "";
    private String loginPass = "";
    private String context = "";
    private boolean disableSSLSecurity = false;

    public void execute() {
        ImpRestServices irs = new ImpRestServices();
        irs.setServerRoot(this.serverPath);
        irs.setContext(this.context);
        irs.setAuthentication(this.loginUser, this.loginPass);
        irs.setExceptionOnNotFoundOnDelete(false);
        irs.setDisableSSLSecurity(this.disableSSLSecurity);
        String appToDel = null;
        if (this.appToBeDeleted.length() > 0) {
            appToDel = this.appToBeDeleted;
            if (this.appOsToBeDeleted.length() > 0) {
                appToDel = appToDel + "@" + this.appOsToBeDeleted;
                if (this.appVersionToBeDeleted.length() > 0) {
                    appToDel = appToDel + "@" + this.appVersionToBeDeleted;
                }
            } else if (this.appVersionToBeDeleted.length() > 0) {
                appToDel = appToDel + "@@" + this.appVersionToBeDeleted;
            }
        }
        if (this.file != null) {
            this.handleFile(irs, this.file);
        } else if (appToDel != null) {
            this.handleAppToBeDeleted(irs, appToDel);
        } else {
            for (FileSet fs : this.filesets) {
                DirectoryScanner ds = fs.getDirectoryScanner();
                String[] files = ds.getIncludedFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = new File(fs.getDir() + "/" + files[i]);
                    this.handleFile(irs, file);
                }
            }
        }
    }

    private void handleFile(ImpRestServices irs, File file) {
        if (!file.exists()) {
            String spec = file.getName();
            this.handleAppToBeDeleted(irs, spec);
        } else {
            this.log("Deleting " + file.getName());
            irs.delete(file);
        }
    }

    private void handleAppToBeDeleted(ImpRestServices irs, String spec) {
        String[] parts = spec.split("@");
        if (parts.length >= 3) {
            irs.delete(parts[0], parts[1], parts[2]);
        } else if (parts.length >= 2) {
            irs.delete(parts[0], parts[1]);
        } else {
            irs.delete(spec);
        }
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setApplication(String application) {
        this.appToBeDeleted = application;
    }

    public void setVersion(String version) {
        this.appVersionToBeDeleted = version;
    }

    public void setOs(String os) {
        this.appOsToBeDeleted = os;
    }

    public void setServerPath(String path) {
        this.serverPath = path;
    }

    public void setLoginUser(String user) {
        this.loginUser = user;
    }

    public void setLoginPass(String pass) {
        this.loginPass = pass;
    }

    public void setContext(String con) {
        this.context = con;
    }

    public String getContext() {
        return this.context;
    }

    public void setDisableSSLSecurity(boolean disable) {
        this.disableSSLSecurity = disable;
    }

    public boolean isDisableSSLSecurity() {
        return this.disableSSLSecurity;
    }
}

