/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.FileUtils;
import com.urbancode.commons.fileutils.filelister.DirectoryFile;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.PermissionViewMap;
import com.urbancode.commons.fileutils.filelister.RegularFile;
import com.urbancode.commons.fileutils.filelister.SymlinkFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedFile {
    private static final Logger log = Logger.getLogger(TypedFile.class);
    public static Comparator<TypedFile> PATH_ORDER = new Comparator<TypedFile>(){

        @Override
        public int compare(TypedFile l, TypedFile r) {
            return l.path().compareTo(r.path());
        }
    };
    private final String path;
    private final PermissionViewMap permissionViews;

    public static TypedFile create(File base, String path, Set<?> permissionViews) throws IOException {
        File actualFile = new File(base.getAbsoluteFile(), path);
        String linkPath = FileUtils.readlink(actualFile);
        if (linkPath == null) {
            if (actualFile.isDirectory()) {
                return TypedFile.createDirectory(path, permissionViews);
            }
            return TypedFile.createRegular(path, permissionViews);
        }
        return TypedFile.createSymlink(path, linkPath);
    }

    public static TypedFile createNoSymlinks(File base, String path, Set<?> permissionViews) throws IOException {
        File file = new File(base, path);
        if (file.isDirectory()) {
            return TypedFile.createDirectory(path, permissionViews);
        }
        return TypedFile.createRegular(path, permissionViews);
    }

    public static TypedFile createRegular(String path, Set<?> permissionViews) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating regular file for path " + path));
        }
        return new RegularFile(path, permissionViews);
    }

    public static TypedFile createRegular(String path) {
        return TypedFile.createRegular(path, Collections.emptySet());
    }

    public static TypedFile createDirectory(String path, Set<?> permissionViews) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating directory file for path " + path));
        }
        return new DirectoryFile(path, permissionViews);
    }

    public static TypedFile createDirectory(String path) {
        return TypedFile.createDirectory(path, Collections.emptySet());
    }

    public static TypedFile createSymlink(String path, String linkPath) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating symlink file for path " + path));
        }
        return new SymlinkFile(path, linkPath);
    }

    protected TypedFile(String path, Set<?> permissionViews) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        path = path.replace('\\', '/');
        if ((path = path.replace(File.separatorChar, '/')).startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        this.permissionViews = new PermissionViewMap(permissionViews);
    }

    public File translate(File base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        return new File(base, this.path());
    }

    public String toString() {
        return (Object)((Object)this.type()) + " " + this.path();
    }

    public <T> T permissionView(Class<T> viewClass) {
        return this.permissionViews.get(viewClass);
    }

    public Set<?> permissionViews() {
        return this.permissionViews.all();
    }

    public String path() {
        return this.path;
    }

    public abstract String linkPath();

    public abstract FileType type();
}

