/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016, 2017 All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.appscan.AppScanRestHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

// Parse timeout property
def timeout = props['timeout'].trim()
timeout = timeout?Integer.parseInt(timeout):60
if (timeout < 5) {
    timeout = 5
}
println "[Ok] Setting timeout to ${timeout} minutes."
props['timeout'] = timeout * 60000 // 1 minute in milliseconds

def helper = new AppScanRestHelper(props)

String status = "UNKNOWN"
int runResult = 1
try {
    println("Executing scan...")
    def result = helper.runScan()
    status = result[0]
    runResult = result[1]
}
catch (Exception ee) {
    throw new Exception("Command failed with message: " + ee.message)
} finally {
    apTool.setOutputProperty("scanStatus", status)
    apTool.setOutputProperties()
}

System.exit(runResult)
