/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016 All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.appscan.AppScanRestHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

def helper = new AppScanRestHelper(props)
int runResult = 1;
try {
    println("Retrieving Report...")
    def outProps = helper.retrieveReportInfo()
    apTool.setOutputProperty("scanStatus", outProps[0])
    runResult = outProps[1]!=null ? outProps[1].toInteger() : 1
    apTool.setOutputProperty("reportSummaryFile", outProps[2])
    apTool.setOutputProperty("reportSpecificFile", outProps[3])
    apTool.setOutputProperty("criticalSevIssues", outProps[4])
    apTool.setOutputProperty("highSevIssues", outProps[5])
    apTool.setOutputProperty("mediumSevIssues", outProps[6])
    apTool.setOutputProperty("lowSevIssues", outProps[7])
    apTool.setOutputProperty("detailsLink", outProps[8])
    apTool.setOutputProperty("reportSpecificURL", outProps[9])
}
catch (Exception ee) {
    ee.printStackTrace()
    throw new Exception("Command failed with message: " + ee.message)
} finally {
    apTool.storeOutputProperties()
}
System.exit(runResult)
