/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2017 All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import org.w3c.dom.Document

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.appscan.AppScanRestHelper
import com.urbancode.air.plugin.appscan.DocUtil

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()
String fiid = props['scanFIID']

// Parse timeout property
def timeout = props['timeout'].trim()
timeout = timeout ? Integer.parseInt(timeout) : 20160 // If not specified two weeks == indefinitely
if (timeout == 20160) {
    println "[Ok] Waiting indefinitely for completed state."
} else {
    println "[Ok] Setting timeout to ${timeout} minutes."
}
props['timeout'] = timeout * 60000 // 1 minute in milliseconds

def helper = new AppScanRestHelper(props)

String status = "UNKNOWN"
int runResult = 1
try {

    // Retrieve Initial Scan/Report Pack Information
    String scanURL = helper.baseUrl + "ase/services/folderitems/" + fiid
    Document doc = helper.sendGetRequest(scanURL)
    String lastRun = DocUtil.getContentScanJob_LastRun(doc)
    println("Last Run: ${lastRun}")

    // Iterate through wait loop
    println("Waiting for scan...")
    def statusInt = helper.waitForCompletion(scanURL, lastRun)
    status = helper.getKey(statusInt)

    if (statusInt == helper.ScanState.READY) {
        runResult = 0
    }
}
catch (Exception ee) {
    throw new Exception("Command failed with message: " + ee.message)
} finally {
    apTool.setOutputProperty("scanStatus", status)
    apTool.setOutputProperties()
}

System.exit(runResult)
