/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016 All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.appscan.AppScanRestHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

def helper = new AppScanRestHelper(props)

try {
    println("Retrieving PDF Report...")
    String[] outProps = helper.retrievePDFReportInfo()
    apTool.setOutputProperty("pdfReportFilePath", outProps[0])
    apTool.setOutputProperty("detailsLink", outProps[1])
}
catch (Exception ee) {
    throw new Exception("Command failed with message: " + ee.message)
} finally {
    apTool.storeOutputProperties()
}
