/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * IBM Urbancode Release
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
package com.urbancode.air.plugin.appscan

import javax.xml.XMLConstants
import javax.xml.namespace.NamespaceContext
import javax.xml.xpath.XPath
import javax.xml.xpath.XPathConstants
import javax.xml.xpath.XPathFactory
import org.w3c.dom.Document

public class DocUtil {

    public static XPath xpath

    public static XPath getXPath() {
        // If null, create it
        if (!xpath) {
            // Initialization of XPath utilities
            XPathFactory xfactory = XPathFactory.newInstance()
            xpath = xfactory.newXPath()
            xpath.setNamespaceContext(_nsContext)
        }
        return xpath
    }

    // Retreives first last-run prop (regardless of scan or report-pack)
    public static String getLastRun(Document doc) {
        return (String) getXPath().evaluate("//last-run/text()", doc, XPathConstants.STRING)
    }

    public static String getContentScanJob_LastRun(Document doc) {
        return (String) getXPath().evaluate("//content-scan-job/last-run/text()", doc, XPathConstants.STRING)
    }

    public static String getReportPack_Reports_href(Document doc) {
        return (String) getXPath().evaluate("//report-pack/reports/@href", doc, XPathConstants.STRING)
    }

    public static String getReportPack_LastRun(Document doc) {
        return (String) getXPath().evaluate("//report-pack/last-run/text()", doc, XPathConstants.STRING)
    }

    public static String getState_Name(Document doc) {
        return (String) getXPath().evaluate("//state/name/text()", doc, XPathConstants.STRING)
    }

    public static Double getState_Id(Document doc) {
        return (Double) getXPath().evaluate("//state/id/text()", doc, XPathConstants.NUMBER)
    }

    public static String getReportName_href(Document doc, String reportName) {
        return (String) getXPath().evaluate("//report[name='${reportName}']/data/@href", doc, XPathConstants.STRING)
    }


    public static String getIssues_Count(Document doc, String reportName, String severity) {
        return (String) getXPath().evaluate("//report[name='${reportName}']/issue-counts-severity/issue-count[severity/name='${severity}']/count/text()", doc, XPathConstants.STRING)
    }



    private static NamespaceContext _nsContext
    static {
        _nsContext = new NamespaceContext() {
            public String getNamespaceURI(String prefix) {
                if (prefix.equalsIgnoreCase("ase"))
                    return "http://www.ibm.com/Rational/AppScanEnterprise"
                return XMLConstants.NULL_NS_URI
            }

            public String getPrefix(String arg0) {
                return null
            }

            public Iterator<?> getPrefixes(String arg0) {
                return null
            }
        }
    }
}
