/*
 * Licensed Materials - Property of IBM* Corp. and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016, 2017 All Rights Reserved.
 * (c) Copyright HCL Corporation 2018, 2019 All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.

 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */


import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.appscan.AppScanRestHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

def helper = new AppScanRestHelper(props)

try {
    println("Creating Scan...")
    String[] outProps = helper.createScanV2()
    
    apTool.setOutputProperty("scanFIID", outProps[0])
    apTool.setOutputProperty("reportsFIID", outProps[1])
    apTool.setOutputProperty("appID", outProps[2])
    apTool.storeOutputProperties()
}
catch (Exception ee) {
    throw new Exception("Command failed with message: " + ee.message)
}
