/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2017 All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import org.w3c.dom.Document

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.appscan.AppScanRestHelper
import com.urbancode.air.plugin.appscan.DocUtil

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

String fiid = props['scanFIID']

// Parse timeout property
def timeout = props['timeout'].trim()
timeout = timeout ? Integer.parseInt(timeout) : 5 // 5 minutes by default
if (timeout == 5) {
    println "[Ok] Waiting for 5 mnutes by default."
} else {
    println "[Ok] Setting timeout to ${timeout} minutes."
}
props['timeout'] = timeout * 60000 // 1 minute in milliseconds

def helper = new AppScanRestHelper(props)

String status = "UNKNOWN"
try {
    println("Waiting for scan...")
    String[] outProps = helper.waitForCompletionV2()
    println "outProps: ${outProps}"
}
catch (Exception ee) {
    throw new Exception("Command failed with message: " + ee.message)
} finally {
    apTool.setOutputProperty("scanStatus", outProps[0])
    apTool.setOutputProperty("scanFIID", outProps[1])

    apTool.setOutputProperties()
}
