/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.concurrent.noop;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class NoopFuture<V>
implements Future<V> {
    private static final Future<?> emptyInstance = NoopFuture.value(null);
    private final V value;

    public static <V> Future<V> empty() {
        return (NoopFuture)emptyInstance;
    }

    public static <V> Future<V> value(V value) {
        return new NoopFuture<V>(value);
    }

    private NoopFuture(V value) {
        this.value = value;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) {
        return this.value;
    }
}

