/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.securedata;

import com.urbancode.air.securedata.SecretContainer2;
import com.urbancode.air.securedata.SecretUnavailableException;
import java.util.Arrays;

public final class SecretContainerDestroyable
implements SecretContainer2 {
    private byte[] secret;
    private final String cryptoSuite;

    public SecretContainerDestroyable(byte[] secret) {
        this(secret, null);
    }

    public SecretContainerDestroyable(byte[] secret, String cryptoSuite) {
        secret.getClass();
        this.secret = secret;
        this.cryptoSuite = cryptoSuite;
    }

    public synchronized void destroy() {
        if (this.secret != null) {
            Arrays.fill(this.secret, (byte)0);
            this.secret = null;
        }
    }

    public synchronized boolean isDestroyed() {
        return this.secret == null;
    }

    public synchronized byte[] getSecret() throws SecretUnavailableException {
        if (this.isDestroyed()) {
            throw new SecretUnavailableException("secret destroyed");
        }
        return this.secret;
    }

    public String getCryptoSuite() {
        return this.cryptoSuite;
    }
}

