/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2024. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.argocd.ArgoCDHelper
import org.apache.log4j.Level
import org.apache.log4j.Logger

// Get step properties
def apTool   = new AirPluginTool(args[0], args[1])
def inProps  = apTool.getStepProperties()

/*
 * We acquire the specified log4j level from the input properties and set the root logger level.
 * This will set the logger level for all loggers retrieved in this step.
 * If the logger level specified is invalid, we default to INFO.
 */
String logLevel = inProps['loggerLevel']
Logger.getRootLogger().setLevel(Level.toLevel(logLevel, Level.INFO))
Logger logger = Logger.getLogger(getClass())

String configname  = inProps['configname']?.trim()
String flags       = inProps['flags']?.trim();
String cmdpath     = inProps['cmdpath']?.trim();

// Set up helper
File workDir = new File(".").canonicalFile
ArgoCDHelper acdh = new ArgoCDHelper(workDir, cmdpath)

/*
 * Need to check that we were given at least one configuration file
 */
if (!configname) {
    println('[Error] The step requires at least one configuration file name or URL to be given')
    System.exit(1)
}

// Create the ApplicationSet create command string
def args = []
args << 'appset'
args << 'create'

args << configname

/*
 * Run the 'appset create' command.
 */
acdh.setFlags(args, flags)
acdh.runCommand("[Action] Creating applicationset...", args) { Process proc ->
    def (String sout, String serr) = acdh.captureCommand(proc)
    println ('[Stderr output]')
    println (serr)
    println ('[Stdout output]')
    println (sout)
}

