/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Build
 * IBM UrbanCode Deploy
 * IBM UrbanCode Release
 * IBM AnthillPro
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2024. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

 package com.urbancode.air.plugin.argocd

 import java.io.IOException;
 import java.net.URI;

 import org.apache.http.client.methods.CloseableHttpResponse;
 import org.apache.http.client.methods.HttpPost;
 import org.apache.http.client.methods.HttpGet;
 import org.apache.http.impl.client.DefaultHttpClient;
 import org.codehaus.jettison.json.JSONException;
 import org.codehaus.jettison.json.JSONObject;

 import com.urbancode.ud.client.UDRestClient;

 class ComponentVersionClient extends UDRestClient {
	 public ComponentVersionClient(URI url, String clientUser, String clientPassword) {
		 super(url, clientUser, clientPassword);
	 }

	 public ComponentVersionClient(URI url, String clientUser, String clientPassword, boolean trustAllCerts) {
		 super(url, clientUser, clientPassword, trustAllCerts);
	 }

	 public ComponentVersionClient(URI url, DefaultHttpClient client) {
		 super(url, client);
	 }

	 public String getVersionLink(String versionName, String componentName, String linkName)
	 throws IOException
	 {
		def versionLink = null;

		if ("".equals(versionName) || "".equals(componentName) || "".equals(linkName)) {
			throw new IOException("a required argument was not supplied");
		}

		String uri = url.toString() + "/cli/version/getLink?version=" +
				encodePath(versionName) + "&linkName=" +
				encodePath(linkName) + "&component=" +
				encodePath(componentName);

		println "uri: " + uri;

		HttpGet method = new HttpGet(uri);
		CloseableHttpResponse response = invokeMethod(method);

		try {
			String body = getBody(response);
		    println "body: [" + body + "]"

		    if (body != null) {
				JSONObject componentVersionLinkInfoJSON = new JSONObject(body);
				versionLink = componentVersionLinkInfoJSON.getString("value");
		    }
		}
		catch (JSONException jse) {
			println "Version link not available: " + jse.toString();
		}
		finally {
			response.close();
		}

		println "versionLink: [" + versionLink + "]";

		return versionLink;
	 }
 }
