/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.plugin.aspera.AsperaHelper

final def apTool   = new AirPluginTool(args[0], args[1])
AsperaHelper helper = new AsperaHelper()
def props          = apTool.getStepProperties()
def asperaFilePath = helper.text2StringList(props['asperaFilePath'])
def asperaUsername = props['asperaUsername']
def asperaHost     = helper.text2HostnameList(props['asperaHost'])[0]
def destFilePath   = props['destFilePath']
def overwrite      = props['overwrite']
def maxRate        = props['maxRate'] as int
def additionalArgs = helper.text2StringList(props['additionalArgs'])
def envPassword    = props['envPassword']
def envToken       = props['envToken']
def envCookie      = props['envCookie']
def envFilePass    = props['envFilePass']
def envProxyPass   = props['envProxyPass']
def scriptLocation = props['scriptLocation']

def exitCode

def workDir = new File(".").canonicalFile
def ch = new CommandHelper(workDir)
final def isWindows = (System.getProperty('os.name') =~ /(?i)windows/).find()
def ascp = isWindows ? "ascp.exe" : "ascp"

// Concat file and path
def fullScriptPath = scriptLocation
if (!fullScriptPath.endsWith(File.separator)) {
    fullScriptPath += File.separator
}
fullScriptPath += ascp

File f = new File(fullScriptPath)
if (!f.isFile()) {
    throw new Exception ("${fullScriptPath} does not exist!")
}

// Construct ascp Command
def args = []

// Set all environment variables
if (envPassword) {
    helper.addEnvVars("ASPERA_SCP_PASS", envPassword, ch)
}
if (envToken) {
    helper.addEnvVars("ASPERA_SCP_TOKEN", envToken, ch)
}
if (envCookie) {
    helper.addEnvVars("ASPERA_SCP_COOKIE", envCookie, ch)
}
if (envFilePass) {
    helper.addEnvVars("ASPERA_SCP_FILEPASS", envFilePass, ch)
}
if (envProxyPass) {
    helper.addEnvVars("ASPERA_PROXY_PASS", envProxyPass, ch)
}

// ascp Script Location
args << fullScriptPath

// Extra Arguments
args << "--overwrite=" + overwrite

if (maxRate > -1) {
    args << "-l " + maxRate
}

for (addArg in additionalArgs) {
    args << addArg
}

// Aspera Login and Host information
// No spaces are allowed in between user, host, and file, but required
// to separate the file strings
def login = ""
if (asperaUsername) {
    login += asperaUsername + "@"
}
login += asperaHost.toString() + ":"

for (file in asperaFilePath) {
    args << login + file
}

// Local Destination Path
args << destFilePath

exitCode = ch.runCommand("Aspera downloading..." , args)

System.exit(exitCode)