/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

package com.urbancode.air.plugin.aspera;

import com.urbancode.air.CommandHelper
import java.net.URI

public class AsperaHelper {

    public AsperaHelper() {
    }

    /**
     * param input Text string with each item separated by commas or new lines
     * result   Helper class for other text2StringList(). Does not remove all
     * whitespace, only uses trim() for the beginning and ending white space.
     * Each element is parsed and place into a List
     */
    public List text2StringList(String input) {
        return text2StringList(input, false)
    }

    // To-Do: Read input from a file.
    /**
     * param input Text string with each item separated by commas or new lines
     * param removeAllSpaces True will remove all spaces in the given text, false
     * will just remove white space at the beginning and end.
     * result   Return a List of elements from the given text
     */
    public List text2StringList(String input, boolean removeAllSpaces) {
        def result
        if (input) {
            result = input.replaceAll('\n', ',').split(',').findAll{
                it && it.trim().size() > 0} as String[]
            if (removeAllSpaces) {
                result = result.collect {it.replaceAll("\\s","")}
            }
            else {
                result = result.collect {it.trim()}
            }
        }
        return result
    }

    /**
     * param input Text string with each item separated by commas or new lines
     * result   Return a List of URL elements from the given text. Some String
     * manipulation is done to remove any unecessary characters. All extra /,
     * https:, and http: are removed.
     */
    public List text2HostnameList(String input) {
        def result
        if (input) {
            // Parse and trim each IPAddress
            result = input.replaceAll('\n', ',').split(',').findAll{
                it && it.trim().size() > 0} as String[]

            // Get each IPAddress, add http:// if necessary, get the hostname
            result = result.collect{
                try {
                    if (!it.startsWith("https://") && !it.startsWith("http://")) {
                        it = "http://" + it
                    }
                    def tempURL = new URL(it)
                    it = tempURL.getHost()
                }
                catch (MalformedURLException ex) {
                    println "Error: The given Host '${it}' is invalid and could not be parsed. "
                }
                catch (Exception ex) {
                    println "Error: The given Host '${it}' is invalid. Please review the URL and confirm its existance."
                }
            }

            // If null, then host was not given -> crash
            result.each{
                if (!it) {
                    throw new Exception ("Invalid Host given: '${it.toString()}'.  Please review and ensure that properly formatted URL is given. Ex: 192.168.0.1 or localhost")
                }
            }
        }
        return result
    }

    /**
     * param key The name of the environment variable you wish to add.
     * param value The value that will be assigned to the chosen key.
     * param ch The command helper prompt where the key and value will be assigned.
     * result The key and value will be added as an environment variable to the
     * given command helper environment. Extensive exception handling is also done.
     */
    public void addEnvVars(String key, String value, CommandHelper ch) {
        if (key && value) {
            try {
                ch.addEnvironmentVariable(key, value)
            } catch(UnsupportedOperationException e) {
                throw new Exception("Enviroment variable, name:${key} value:${value}, not loaded. System may not allow modifications to environment variables or may forbid certain variable names or values.")
            } catch(IllegalArgumentException e) {
                throw new Exception("Enviroment variable, name:${key} value:${value}, not loaded. System may not allow modifications to environment variables or may forbid certain variable names or values.")
            } catch(SecurityException e) {
                throw new Exception("Enviroment variables not loaded. A security manager exists and its checkPermission method does not allow access to the process environment.")
            }
        }
        else {
            println("Enviroment variable, name:${key} value:${value}, not loaded. Must contain both name and value.")
        }
    }
}