/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import org.apache.http.impl.client.DefaultHttpClient
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.bigfix.BigFixHelper
import com.urbancode.air.plugin.bigfix.TextBoxHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

BigFixHelper bf  = new BigFixHelper()
TextBoxHelper tb = new TextBoxHelper()

def xmlAction    = tb.getXMLText(props['xmlAction'])
def hostname     = bf.checkHostname(props['hostname'])
def username     = props['username']
def password     = props['password']

// Create the REST call and run
DefaultHttpClient client = bf.createClient(username, password)
def statusCode = bf.startAction(client, hostname, xmlAction)

//Set an output property
apTool.setOutputProperty("StatusCode", Integer.toString(statusCode))
apTool.storeOutputProperties()

// If the StatusCode is not in 200s, then crash
if (Math.floor(statusCode/100) != 2) {
    System.exit(1)
}

