/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.crypto.algs;

import com.urbancode.commons.util.crypto.SecureEquals;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractCryptStringAlgorithm {
    protected final byte[] getUtf8Bytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported, but this is required in JVM spec", e);
        }
    }

    protected final String toUTF8String(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    protected final char[] getAsciiChars(byte[] value) {
        try {
            char[] chars = new String(value, "US-ASCII").toCharArray();
            return chars;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("US-ASCII is unsupported, but this is required in JVM spec", e);
        }
    }

    protected final String encodeBase64String(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    protected final byte[] decodeBase64(String string) {
        return Base64.decodeBase64((String)string);
    }

    protected final boolean secureEquals(String string1, String string2) {
        return SecureEquals.secureEquals(string1, string2);
    }
}

