/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.cf.ic.helper.CFICHelper

AirPluginTool apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

final def workDir = new File('.').canonicalFile
def commandPath = props['commandPath']

CFICHelper icHelper = new CFICHelper(workDir, commandPath)
def exportStatements

try {
    exportStatements = icHelper.initialize()
    println("Authentication token successfully initialized.")
}
catch(ExitCodeException ex) {
    println("Could not successfully initialize command-line interface.")
    println(ex)
    System.exit(1)
}

def dockerHost = exportStatements[0].split("=")[1]
def dockerCertPath = exportStatements[1].split("=")[1]
apTool.setOutputProperty("cfic.dockerHost", dockerHost)
apTool.setOutputProperty("cfic.dockerCertPath", dockerCertPath)
apTool.setOutputProperties()