/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.cf.ic.helper.CFICHelper

AirPluginTool apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

final def workDir = new File('.').canonicalFile
def commandPath = props['commandPath']
def namespace = props['namespace'].trim()
def onFail = props['onFail']

CFICHelper icHelper = new CFICHelper(workDir, commandPath)

try {
    icHelper.setNamespace(namespace, onFail)
    println("Successfully set namespace: ${namespace}")
}
catch(ExitCodeException ex) {
    println("Could not succcessfully set namespace: ${namespace}")
    println(ex)
    System.exit(1)
}