/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.cf.ic.helper.CFICHelper

AirPluginTool apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

final def workDir = new File('.').canonicalFile
def commandPath = props['commandPath']
def api = props['api'].trim()
def org = props['org'].trim()
def space = props['space'].trim()
def user = props['user'].trim()
def password = props['password'].trim()

CFICHelper icHelper = new CFICHelper(workDir, commandPath)

try {
    icHelper.login(user, password, api, org, space)
    println("Successfully logged into Cloud Foundry instance.")
}
catch(ExitCodeException ex) {
    println("Could not successfully log into Cloud Foundry instance.")
    println(ex)
    System.exit(1)
}