/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.cf.ic.helper.CFICHelper

AirPluginTool apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

final def workDir = new File('.').canonicalFile
def commandPath = props['commandPath']
def pluginPath = props['pluginPath']

CFICHelper icHelper = new CFICHelper(workDir, commandPath)

try {
    pluginPath = icHelper.installCFICPlugin(pluginPath)
    println("IBM Containers plugin successfully installed")
}
catch(ExitCodeException ex) {
    println("Could not successfully install IBM Containers plugin from path: ${pluginPath}")
    println(ex)
    System.exit(1)
}