/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.cf.ic.helper.CFICHelper

AirPluginTool apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

final def workDir = new File('.').canonicalFile
def commandPath = props['commandPath']
def image = props['image'].trim()
def groupName = props ['groupName'].trim()
def hostname = props['hostname'].trim()
def domain = props['domain'].trim()
def port = props['port'].trim()
def environment = props['environment'].trim()
def minInstances = props['minInstances'].trim()
def maxInstances = props['maxInstances'].trim()
def desiredInstances = props['desiredInstances'].trim()
def additionalArgs = props['additionalArgs'].trim()

CFICHelper icHelper = new CFICHelper(workDir, commandPath)

try {
    icHelper.createGroup(
        image,
        groupName,
        hostname,
        domain,
        port,
        environment,
        minInstances,
        maxInstances,
        desiredInstances,
        additionalArgs)

    println("Successfully created container group: ${groupName}")
}
catch(ExitCodeException ex) {
    println("Could not create container group: ${groupName}")
    println(ex)
    System.exit(1)
}