/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.cf.ic.helper.CFICHelper

AirPluginTool apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

final def workDir = new File('.').canonicalFile
def commandPath = props['commandPath']
def container = props['container'].trim()
def command = props['command'].trim()
def additionalArgs = props['additionalArgs'].trim()

CFICHelper icHelper = new CFICHelper(workDir, commandPath)

try {
    icHelper.executeCommand(container, command, additionalArgs)
    println("Executed command successfully on container: ${container}")
}
catch(ExitCodeException ex) {
    println("Could not execute command: '${command}' successfully on container: ${container}")
    println(ex)
    System.exit(1)
}