/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.authentication;

import com.urbancode.commons.web.WebConfig;
import com.urbancode.commons.web.WebException;
import com.urbancode.commons.web.controller.RequestHandler;
import com.urbancode.commons.web.controller.RequestHandlerHelper;
import com.urbancode.persistence.PersistenceException;
import com.urbancode.security.SecurityManager;
import com.urbancode.security.SecurityUser;
import com.urbancode.security.Team;
import com.urbancode.security.authentication.AbstractAuthenticator;
import com.urbancode.security.authentication.AuthenticationException;
import com.urbancode.security.authentication.CurrentUserHelper;
import com.urbancode.security.authentication.TeamDisabledAuthenticationException;
import com.urbancode.security.authentication.UserDisabledAuthenticationException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HttpAuthenticator {
    private static final String USER_KEY = HttpAuthenticator.class.getName() + ".User";

    public static SecurityUser authenticate(HttpServletRequest request, HttpServletResponse response, boolean cookie, boolean form) throws WebException, AuthenticationException, PersistenceException {
        SecurityUser result = HttpAuthenticator.getAuthenticatedUser(request);
        if (result == null) {
            if (cookie) {
                result = WebConfig.getInstance().getCookieAuthenticator().authenticate(request, response);
            }
            if (form && result == null) {
                String password;
                RequestHandler requestHandler = new RequestHandlerHelper().getRequestHandler(request);
                String loginName = requestHandler.getString("login");
                if (loginName == null) {
                    loginName = (String)request.getAttribute("login");
                }
                if ((password = requestHandler.getString("password")) == null) {
                    password = (String)request.getAttribute("password");
                }
                boolean rememberMe = requestHandler.getBoolean("rememberMe");
                if (loginName != null && loginName.length() > 0 && password != null && password.length() > 0) {
                    AbstractAuthenticator authenticator = SecurityManager.getInstance().getAuthenticator();
                    result = authenticator.authenticate((Object)request, loginName, password);
                }
                if (CurrentUserHelper.hasCurrent()) {
                    CurrentUserHelper.getCurrent().unbindThread();
                }
                if (result != null) {
                    CurrentUserHelper currentUserHelper = new CurrentUserHelper(result);
                    currentUserHelper.bindCurrentThread();
                }
                if (result != null && response != null && rememberMe) {
                    WebConfig.getInstance().getCookieAuthenticator().store(loginName, password, request, response);
                }
            }
        }
        if (result != null) {
            if (!result.isEnabled()) {
                throw new UserDisabledAuthenticationException("User disabled");
            }
            List teams = result.getTeams();
            if (teams.size() == 1 && !((Team)teams.get(0)).isEnabled()) {
                throw new TeamDisabledAuthenticationException("Team disabled");
            }
        }
        HttpSession session = request.getSession();
        session.setAttribute(USER_KEY, (Object)result);
        return result;
    }

    public static SecurityUser getAuthenticatedUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        SecurityUser result = (SecurityUser)session.getAttribute(USER_KEY);
        return result;
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        session.removeAttribute(USER_KEY);
        session.invalidate();
        if (CurrentUserHelper.hasCurrent()) {
            CurrentUserHelper.getCurrent().unbindThread();
        }
        if (response != null) {
            WebConfig.getInstance().getCookieAuthenticator().delete(request, response);
        }
    }
}

