/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTaskMirrorImpl;

public class JUnitVersionHelper {
    private static Method testCaseName = null;
    public static final String JUNIT_FRAMEWORK_JUNIT4_TEST_CASE_FACADE = "junit.framework.JUnit4TestCaseFacade";
    private static final String UNKNOWN_TEST_CASE_NAME = "unknown";

    public static String getTestCaseName(Test t) {
        block11: {
            if (t == null) {
                return UNKNOWN_TEST_CASE_NAME;
            }
            if (t.getClass().getName().equals(JUNIT_FRAMEWORK_JUNIT4_TEST_CASE_FACADE)) {
                String name = t.toString();
                if (name.endsWith(")")) {
                    int paren = name.lastIndexOf(40);
                    return name.substring(0, paren);
                }
                return name;
            }
            if (t instanceof TestCase && testCaseName != null) {
                try {
                    return (String)testCaseName.invoke((Object)t, new Object[0]);
                }
                catch (Throwable ignored) {
                    break block11;
                }
            }
            try {
                Method getNameMethod = null;
                try {
                    getNameMethod = t.getClass().getMethod("getName", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    getNameMethod = t.getClass().getMethod("name", new Class[0]);
                }
                if (getNameMethod != null && getNameMethod.getReturnType() == String.class) {
                    return (String)getNameMethod.invoke((Object)t, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return UNKNOWN_TEST_CASE_NAME;
    }

    public static String getTestCaseClassName(Test test) {
        String name;
        int paren;
        String className = test.getClass().getName();
        if (test instanceof JUnitTaskMirrorImpl.VmExitErrorTest) {
            className = ((JUnitTaskMirrorImpl.VmExitErrorTest)test).getClassName();
        } else if (className.equals(JUNIT_FRAMEWORK_JUNIT4_TEST_CASE_FACADE) && (paren = (name = test.toString()).lastIndexOf(40)) != -1 && name.endsWith(")")) {
            className = name.substring(paren + 1, name.length() - 1);
        }
        return className;
    }

    public static String getIgnoreMessage(Test test) {
        String message = null;
        try {
            Method valueMethod;
            String value;
            Class<?> ignoreAnnotation;
            Class<?> testClass;
            Method testMethod;
            Object annotation;
            Class<?> junit4FacadeClass = Class.forName(JUNIT_FRAMEWORK_JUNIT4_TEST_CASE_FACADE);
            if (test != null && test.getClass().isAssignableFrom(junit4FacadeClass) && (annotation = (testMethod = (testClass = Class.forName(JUnitVersionHelper.getTestCaseClassName(test))).getMethod(JUnitVersionHelper.getTestCaseName(test), new Class[0])).getAnnotation(ignoreAnnotation = Class.forName("org.junit.Ignore"))) != null && (value = (String)(valueMethod = annotation.getClass().getMethod("value", new Class[0])).invoke(annotation, new Object[0])) != null && value.length() > 0) {
                message = value;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return message;
    }

    static {
        try {
            testCaseName = TestCase.class.getMethod("getName", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                testCaseName = TestCase.class.getMethod("name", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }
}

