/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.NamedParams;
import com.ibm.dcm.SSLConnection;
import com.ibm.dcm.Soma;
import com.ibm.dcm.SomaUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.XMLFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class taskWdp
extends XMLFragment {
    private String operation = null;
    private String successProperty = null;
    private String responseProperty = null;
    private String xpath = null;
    private String xpathProperty = null;
    private String xpathType = null;
    private String ifProperty = null;
    private String unlessProperty = null;
    private boolean dumpInput = false;
    private boolean dumpOutput = false;
    private String capturesoma = null;
    private static SSLConnection singletonConnection = null;
    private static Soma singletonSoma = null;

    public static Soma getSoma() throws Exception {
        if (singletonSoma == null) {
            singletonConnection = new SSLConnection();
            singletonSoma = new Soma(singletonConnection);
        }
        return singletonSoma;
    }

    public void setOperation(String op) {
        this.operation = op;
    }

    public void setResponseprop(String propname) {
        if (propname.length() > 0) {
            this.responseProperty = propname;
        }
    }

    public void setSuccessprop(String propname) {
        if (propname.length() > 0) {
            this.successProperty = propname;
        }
    }

    public void setXpath(String xpath) {
        if (xpath.length() > 0) {
            this.xpath = xpath;
        }
    }

    public void setXpathprop(String propname) {
        if (propname.length() > 0) {
            this.xpathProperty = propname;
        }
    }

    public void setXpathtype(String typename) {
        if (typename.length() > 0) {
            this.xpathType = typename;
        }
    }

    public void setIf(String propname) {
        if (propname.length() > 0) {
            this.ifProperty = propname;
        }
    }

    public void setUnless(String propname) {
        if (propname.length() > 0) {
            this.unlessProperty = propname;
        }
    }

    public void setDumpinput(boolean flag) {
        this.dumpInput = flag;
    }

    public void setDumpoutput(boolean flag) {
        this.dumpOutput = flag;
    }

    public void setCapturesoma(String filename) {
        this.capturesoma = filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() {
        Project proj = this.getProject();
        NamedParams params = new NamedParams();
        if (this.operation == null) {
            throw new RuntimeException("<wdp> requires an operation=\"...\" attribute.");
        }
        params.set("soma", this.operation);
        NodeList kids = this.getFragment().getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node node = kids.item(i);
            if (node.getNodeType() == 1 && !node.getNodeName().equals("return")) {
                try {
                    this.setParam(params, node);
                }
                catch (Exception e) {}
                continue;
            }
            if (node.getNodeType() != 3) continue;
            try {
                Node doc = SomaUtils.getDOM("<wrapper>" + node.getTextContent() + "</wrapper>");
                if (doc == null) continue;
                for (Node kid = doc.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                    if (kid.getNodeType() != 1) continue;
                    this.setParam(params, kid);
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (params.get("port") == null || params.get("port").equals("")) {
            params.set("port", "5550");
        }
        if (this.dumpInput) {
            System.out.println("<wdp> input:");
            System.out.println(params.dump());
            params.set("dumpinput", "true");
        }
        if (this.dumpOutput) {
            params.set("dumpoutput", "true");
        }
        if (this.capturesoma != null && !this.capturesoma.isEmpty()) {
            params.set("capturesoma", this.capturesoma);
        }
        boolean doIt = true;
        if (this.ifProperty != null && (proj.getProperty(this.ifProperty) == null || proj.getProperty(this.ifProperty).equals("false"))) {
            doIt = false;
        }
        if (this.unlessProperty != null && proj.getProperty(this.unlessProperty) != null && proj.getProperty(this.unlessProperty).equals("true")) {
            doIt = false;
        }
        if (doIt) {
            NamedParams result = params;
            try {
                result = taskWdp.getSoma().performOperation(params);
                if (this.successProperty != null) {
                    proj.setProperty(this.successProperty, "true");
                }
                if (this.responseProperty != null) {
                    String rawresponse = result.get("rawresponse");
                    if (rawresponse != null) {
                        proj.setProperty(this.responseProperty, rawresponse);
                    } else {
                        proj.setProperty(this.responseProperty, "");
                    }
                }
                if (this.xpath == null || this.xpathProperty == null) return;
                String xpathResult = "";
                String rawresponse = result.get("rawresponse");
                if (rawresponse != null) {
                    xpathResult = this.xpathType != null && this.xpathType.equals("node") ? this.expungeWrappers(SomaUtils.nodeXpathFor(SomaUtils.getDOM(rawresponse), this.xpath)) : SomaUtils.stringXpathFor(SomaUtils.getDOM(rawresponse), this.xpath);
                }
                proj.setProperty(this.xpathProperty, xpathResult);
                return;
            }
            catch (Exception e) {
                if (this.successProperty == null) throw new BuildException((Throwable)e);
                result.set("wdp.exception.message", e.getMessage());
                return;
            }
            finally {
                if (result != null) {
                    for (int i = 0; i < kids.getLength(); ++i) {
                        Node node = kids.item(i);
                        if (node.getNodeType() != 1 || !node.getNodeName().equals("return")) continue;
                        String antname = ((Element)node).getAttribute("antprop");
                        String somaname = ((Element)node).getAttribute("somaprop");
                        if (antname.length() <= 0 || somaname.length() <= 0 || result.get(somaname) == null) continue;
                        proj.setProperty(antname, result.get(somaname));
                    }
                    if (this.dumpOutput) {
                        System.out.println("<wdp> output:");
                        System.out.println(result.dump());
                    }
                }
            }
        } else {
            if (this.successProperty == null) return;
            proj.setProperty(this.successProperty, "false");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParam(NamedParams params, Node root) throws Exception {
        boolean debug = false;
        if (root == null) return;
        if (debug) {
            System.out.println("setParam: working on " + this.serializeXML(root));
        }
        String key = root.getNodeName();
        String value = "";
        if (root.getNodeType() == 1 && root.getNodeName().equals("wrapper")) {
            Node node = this.findFirstNonWrapperElement(SomaUtils.getDOM(root.getTextContent()));
            if (node == null) throw new RuntimeException("A <wrapper> element was found that does not contain a child element (e.g. <wrapper><a/></wrapper>");
            key = node.getNodeName();
            value = this.expungeWrappers(node.getFirstChild());
        } else {
            value = this.serializeXML(root.getFirstChild());
        }
        params.set(key, value);
        if (!debug) return;
        System.out.println("setParam: " + key + "=" + value);
    }

    private Node findFirstNonWrapperElement(Node node) {
        return this.findFirstNonWrapperElement(node, false);
    }

    private Node findFirstNonWrapperElement(Node node, boolean doSiblings) {
        Node ret = null;
        boolean debug = false;
        if (node != null) {
            if (debug) {
                System.out.println("$$$ node type = " + node.getNodeType() + ", doSibling=" + doSiblings);
            }
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("wrapper")) {
                    if (debug) {
                        System.out.println("$$$ found <wrapper>, checking first child.");
                    }
                    ret = this.findFirstNonWrapperElement(node.getFirstChild(), true);
                } else {
                    if (debug) {
                        System.out.println("$$$ found <" + node.getNodeName() + ">, finished");
                    }
                    ret = node;
                }
            } else if (node.getNodeType() == 9) {
                ret = this.findFirstNonWrapperElement(node.getFirstChild(), true);
            }
            if (ret == null && doSiblings) {
                if (debug) {
                    if (node.getNextSibling() == null) {
                        System.out.println("$$$  recursing - " + this.serializeXML(node));
                        System.out.println("$$$  recursing but the next sibling is null!");
                    } else {
                        System.out.println("$$$  recursing on some node");
                    }
                }
                ret = this.findFirstNonWrapperElement(node.getNextSibling(), true);
            }
        } else if (debug) {
            System.out.println("$$$  node = null - simply returning");
        }
        return ret;
    }

    private String expungeWrappers(Node node) {
        StringBuffer buf = new StringBuffer();
        if (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("wrapper")) {
                    buf.append(this.expungeWrappers(node.getFirstChild()));
                } else if (node.getFirstChild() != null) {
                    buf.append("<" + node.getNodeName() + " ");
                    NamedNodeMap attrs = ((Element)node).getAttributes();
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node attr = attrs.item(k);
                        buf.append(attr.getNodeName() + "=\"" + attr.getNodeValue() + "\" ");
                    }
                    buf.append(">");
                    buf.append(this.expungeWrappers(node.getFirstChild()));
                    buf.append("</" + node.getNodeName() + ">");
                } else {
                    buf.append("<" + node.getNodeName() + " ");
                    NamedNodeMap attrs = ((Element)node).getAttributes();
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node attr = attrs.item(k);
                        buf.append(attr.getNodeName() + "=\"" + attr.getNodeValue() + "\" ");
                    }
                    buf.append("/>");
                }
            } else if (node.getNodeType() == 3) {
                buf.append(node.getNodeValue());
            } else if (node.getNodeType() == 8) {
                buf.append("<!--" + node.getNodeValue() + "-->");
            } else {
                throw new RuntimeException("Unable to handle node type " + node.getNodeType());
            }
            buf.append(this.expungeWrappers(node.getNextSibling()));
        }
        return buf.toString();
    }

    private String serializeXML(Node node) {
        StringBuffer buf = new StringBuffer();
        if (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getFirstChild() != null) {
                    buf.append("<" + node.getNodeName() + " ");
                    NamedNodeMap attrs = ((Element)node).getAttributes();
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node attr = attrs.item(k);
                        buf.append(attr.getNodeName() + "=\"" + attr.getNodeValue() + "\" ");
                    }
                    buf.append(">");
                    buf.append(this.serializeXML(node.getFirstChild()));
                    buf.append("</" + node.getNodeName() + ">");
                } else {
                    buf.append("<" + node.getNodeName() + " ");
                    NamedNodeMap attrs = ((Element)node).getAttributes();
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node attr = attrs.item(k);
                        buf.append(attr.getNodeName() + "=\"" + attr.getNodeValue() + "\" ");
                    }
                    buf.append("/>");
                }
            } else if (node.getNodeType() == 3) {
                buf.append(node.getNodeValue());
            } else if (node.getNodeType() == 8) {
                buf.append("<!--" + node.getNodeValue() + "-->");
            } else {
                throw new RuntimeException("Unable to handle node type " + node.getNodeType());
            }
            buf.append(this.serializeXML(node.getNextSibling()));
        }
        return buf.toString();
    }
}

