/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.SomaUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class taskForXpath
extends Task {
    private String inProp = "";
    private String inFile = "";
    private String xpath = "";
    private String xpathType = "text";
    private String propname = "forxpath";
    private boolean debug = false;
    private MacroDef baseMacroDef = new MacroDef();

    public taskForXpath() {
        this.baseMacroDef.setProject(this.getProject());
    }

    public Object createSequential() {
        return this.baseMacroDef.createSequential();
    }

    public void setInprop(String propname) {
        this.inProp = propname;
    }

    public void setInfile(String filename) {
        this.inFile = filename;
    }

    public void setXpath(String text) {
        this.xpath = text;
    }

    public void setXpathtype(String text) {
        this.xpathType = text;
    }

    public void setPropname(String text) {
        this.propname = text;
    }

    public void setDebug(String text) {
        String lc = text.toLowerCase();
        if (lc.equals("true") || lc.equals("on") || lc.equals("enable") || lc.equals("enabled") || lc.equals("1")) {
            this.debug = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        MacroDef.Attribute attrForxpath = new MacroDef.Attribute();
        attrForxpath.setName(this.propname);
        this.baseMacroDef.addConfiguredAttribute(attrForxpath);
        Project proj = this.getProject();
        try {
            if ((this.inProp + this.inFile).length() == 0 || this.inProp != "" && this.inFile != "") {
                throw new BuildException("The <forxpath> task requires XML either from an ANT property (inprop) or a file/url (infile), which are mutually exclusive.");
            }
            if (this.xpath.length() == 0) {
                throw new BuildException("The <forxpath> task requires an xpath=\"...\" attribute.");
            }
            if (!this.xpathType.equals("text") && !this.xpathType.equals("node")) {
                throw new BuildException("xpathtype=\"(text|node)\" where 'text' is the string() value of the node returned by the xpath and 'node' is the serialized form of the node.");
            }
            String xml = "";
            if (this.inProp != "") {
                xml = proj.getProperty(this.inProp);
            } else {
                File file = new File(this.inFile);
                byte[] buffer = new byte[(int)file.length()];
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.inFile));
                try {
                    input.read(buffer);
                }
                finally {
                    input.close();
                }
                xml = new String(buffer);
            }
            if (this.debug) {
                System.out.println("### xml=" + xml);
            }
            Node doc = SomaUtils.getDOM(xml);
            NodeList nl = SomaUtils.nodelistXpathFor(doc, this.xpath);
            for (int i = 0; i < nl.getLength(); ++i) {
                String forxpath = nl.item(i).getTextContent();
                if (this.xpathType.equals("node")) {
                    forxpath = SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nl.item(i)));
                }
                if (this.debug) {
                    System.out.println("### " + i + " : " + this.xpathType + " : " + forxpath);
                }
                MacroInstance runme = new MacroInstance();
                runme.setProject(this.getProject());
                runme.setOwningTarget(this.getOwningTarget());
                runme.setMacroDef(this.baseMacroDef);
                runme.setDynamicAttribute(this.propname, forxpath);
                runme.execute();
                continue;
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

