/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class Base64 {
    private static final int[] binaryToBase64 = new int[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final int[] base64ToBinary = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 62, 255, 255, 255, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 255, 255, 255, 0, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 255, 255, 255, 255, 255, 255, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 255, 255, 255, 255, 255};

    public static byte[] toBase64(byte[] in, byte[] out) {
        int needed = ((int)((long)in.length * 4L / 3L) + 3) / 4 * 4;
        byte[] result = out;
        if (result == null || needed > result.length) {
            result = new byte[needed];
        }
        int inOffset = 0;
        int outOffset = 0;
        while (inOffset < in.length) {
            int count = in.length - inOffset;
            if (count > 3) {
                count = 3;
            }
            switch (count) {
                case 1: {
                    result[outOffset + 0] = (byte)binaryToBase64[in[inOffset] >> 2 & 0x3F];
                    result[outOffset + 1] = (byte)binaryToBase64[(in[inOffset] & 3) << 4];
                    result[outOffset + 2] = 61;
                    result[outOffset + 3] = 61;
                    break;
                }
                case 2: {
                    result[outOffset + 0] = (byte)binaryToBase64[in[inOffset] >> 2 & 0x3F];
                    result[outOffset + 1] = (byte)binaryToBase64[(in[inOffset] & 3) << 4 | in[inOffset + 1] >> 4 & 0xF];
                    result[outOffset + 2] = (byte)binaryToBase64[(in[inOffset + 1] & 0xF) << 2];
                    result[outOffset + 3] = 61;
                    break;
                }
                case 3: {
                    result[outOffset + 0] = (byte)binaryToBase64[in[inOffset] >> 2 & 0x3F];
                    result[outOffset + 1] = (byte)binaryToBase64[(in[inOffset] & 3) << 4 | in[inOffset + 1] >> 4 & 0xF];
                    result[outOffset + 2] = (byte)binaryToBase64[(in[inOffset + 1] & 0xF) << 2 | in[inOffset + 2] >> 6 & 3];
                    result[outOffset + 3] = (byte)binaryToBase64[in[inOffset + 2] & 0x3F];
                    break;
                }
            }
            inOffset += 3;
            outOffset += 4;
        }
        return result;
    }

    public static byte[] fromBase64(byte[] in, byte[] out) {
        if (in.length % 4 != 0) {
            throw new RuntimeException("Base64 input must be a multiple of 4 characters.");
        }
        int needed = in.length * 3 / 4;
        byte[] result = out;
        if (result == null || needed > result.length) {
            result = new byte[needed];
        }
        int originalLength = 0;
        int inOffset = 0;
        int outOffset = 0;
        while (inOffset < in.length) {
            int sextet0 = base64ToBinary[in[inOffset]];
            int sextet1 = base64ToBinary[in[inOffset + 1]];
            int sextet2 = base64ToBinary[in[inOffset + 2]];
            int sextet3 = base64ToBinary[in[inOffset + 3]];
            if (sextet0 < 0 || sextet0 > 255) {
                throw new RuntimeException("Non-base64 character encountered at offset " + Integer.toString(inOffset + 0));
            }
            if (sextet1 < 0 || sextet1 > 255) {
                throw new RuntimeException("Non-base64 character encountered at offset " + Integer.toString(inOffset + 1));
            }
            if (sextet2 < 0 || sextet2 > 255) {
                throw new RuntimeException("Non-base64 character encountered at offset " + Integer.toString(inOffset + 2));
            }
            if (sextet3 < 0 || sextet3 > 255) {
                throw new RuntimeException("Non-base64 character encountered at offset " + Integer.toString(inOffset + 3));
            }
            byte one = (byte)(sextet0 << 2 | sextet1 >>> 4);
            byte two = (byte)((sextet1 & 0xF) << 4 | sextet2 >>> 2);
            byte three = (byte)((sextet2 & 3) << 6 | sextet3);
            if (in[inOffset + 3] == 61) {
                if (in[inOffset + 2] == 61) {
                    ++originalLength;
                    result[outOffset + 0] = one;
                } else {
                    originalLength += 2;
                    result[outOffset + 0] = one;
                    result[outOffset + 1] = two;
                }
            } else {
                originalLength += 3;
                result[outOffset + 0] = one;
                result[outOffset + 1] = two;
                result[outOffset + 2] = three;
            }
            inOffset += 4;
            outOffset += 3;
        }
        if (originalLength != result.length) {
            byte[] tmp = new byte[originalLength];
            System.arraycopy(result, 0, tmp, 0, originalLength);
            result = tmp;
        }
        return result;
    }

    public static void base64ToBinaryFile(String base64Input, String filename) {
        byte[] binary = Base64.fromBase64(base64Input.getBytes(), null);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            ((OutputStream)out).write(binary);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String base64FromBinaryFile(String filename) {
        String ret = "";
        try {
            File file = new File(filename);
            byte[] buffer = new byte[(int)file.length()];
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(filename));
            try {
                input.read(buffer);
            }
            finally {
                input.close();
            }
            ret = Base64.bytesToString(Base64.toBase64(buffer, null));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static String bytesToString(byte[] ary) {
        StringBuffer ret = new StringBuffer(ary.length);
        for (int i = 0; i < ary.length; ++i) {
            ret.append((char)ary[i]);
        }
        return ret.toString();
    }
}

