/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.Base64;
import com.ibm.dcm.NamedParams;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;

public class SSLConnection {
    private static X509Certificate[] certChain = null;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
            SSLConnection.access$002(certs);
        }
    }};
    private SSLContext context;

    public SSLConnection() throws Exception {
        try {
            this.context = SSLContext.getInstance("TLSv1.2");
        }
        catch (NoSuchAlgorithmException e0) {
            try {
                this.context = SSLContext.getInstance("TLSv1.1");
            }
            catch (NoSuchAlgorithmException e1) {
                this.context = SSLContext.getInstance("TLSv1");
            }
        }
        this.context.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(this.context.getSocketFactory());
    }

    public NamedParams sendAndReceive(NamedParams params, String request) throws Exception {
        return this.sendAndReceive(params, request, "/service/mgmt/current");
    }

    public NamedParams sendAndReceive(NamedParams params, String request, String method) throws Exception {
        String capturesoma;
        String hostname = params.get("hostname");
        if (params.get("host") != null) {
            hostname = params.get("host");
        }
        String url = "https://" + hostname + ":" + params.get("port") + method;
        boolean dumpinput = false;
        if (params.get("dumpinput") != null && params.get("dumpinput").equals("true")) {
            dumpinput = true;
        }
        boolean dumpoutput = false;
        if (params.get("dumpoutput") != null && params.get("dumpoutput").equals("true")) {
            dumpoutput = true;
        }
        if ((capturesoma = params.get("capturesoma")) != null && capturesoma.isEmpty()) {
            capturesoma = null;
        }
        String rawresponse = this.sendAndReceive(url, params.get("uid"), params.get("pwd"), request, dumpinput, dumpoutput, capturesoma);
        NamedParams result = new NamedParams(params);
        result.set("request", request);
        result.set("rawresponse", rawresponse);
        return result;
    }

    public String sendAndReceive(String dpurl, String uid, String pwd, String request) throws Exception {
        return this.sendAndReceive(dpurl, uid, pwd, request, false, false, null);
    }

    public String sendAndReceive(String dpurl, String uid, String pwd, String request, boolean dumpinput, boolean dumpoutput) throws Exception {
        return this.sendAndReceive(dpurl, uid, pwd, request, dumpinput, dumpoutput, null);
    }

    public String sendAndReceive(String dpurl, String uid, String pwd, String request, boolean dumpinput, boolean dumpoutput, String capturesoma) throws Exception {
        String result = "";
        HttpsURLConnection conn = null;
        Writer out = null;
        BufferedReader in = null;
        BufferedWriter capture = null;
        try {
            if (capturesoma != null && !capturesoma.isEmpty()) {
                capture = new BufferedWriter(new FileWriter(capturesoma, true));
                capture.write("\r\n{{ b48397ae-5fff-4438-97c0-d79f88bb243e }}\r\n[[request " + dpurl + "]]\r\n");
                capture.write(request);
                capture.flush();
            }
            long beginRequestMillis = System.currentTimeMillis();
            conn = (HttpsURLConnection)new URL(dpurl).openConnection();
            conn.setHostnameVerifier(new VeryTrustingHostNameVerifier());
            conn.setUseCaches(false);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            String authString = uid + ":" + pwd;
            conn.setRequestProperty("Authorization", "Basic " + Base64.bytesToString(Base64.toBase64(authString.getBytes(), null)));
            if (dumpinput) {
                System.out.println("SSLConnection.sendAndReceive sent to " + dpurl + " :");
                System.out.println(request);
            }
            out = new OutputStreamWriter(conn.getOutputStream());
            out.write(request);
            out.flush();
            long endRequestMillis = System.currentTimeMillis();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = in.readLine()) != null && !line.equals(null)) {
                sb.append(line);
            }
            result = sb.toString();
            long endResponseMillis = System.currentTimeMillis();
            if (dumpoutput) {
                System.out.println("SSLConnection.sendAndReceive received:");
                System.out.println(result);
            }
            if (capture != null) {
                capture.write("\r\n{{ b48397ae-5fff-4438-97c0-d79f88bb243e }}\r\n[[response (req " + (endRequestMillis - beginRequestMillis) + " ms, resp " + (endResponseMillis - endRequestMillis) + " ms) msg=" + conn.getResponseMessage() + "]]\r\n");
                capture.write(result);
                capture.close();
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (capture != null) {
                try {
                    capture.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            throw e;
        }
        return result;
    }

    public String getCertChain(String hostname, int port) throws Exception {
        certChain = null;
        SSLSocket socket = (SSLSocket)this.context.getSocketFactory().createSocket(hostname, port);
        socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
        socket.setSoTimeout(5000);
        socket.startHandshake();
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<certchain>\n");
        if (certChain != null) {
            for (int i = 0; i < certChain.length; ++i) {
                xml.append("  <cert>\n");
                xml.append("    <subjectDN>" + certChain[i].getSubjectX500Principal().getName() + "</subjectDN>\n");
                xml.append("    <issuerDN>" + certChain[i].getIssuerX500Principal().getName() + "</issuerDN>\n");
                xml.append("    <notBefore>" + certChain[i].getNotBefore().toString() + "</notBefore>\n");
                xml.append("    <notAfter>" + certChain[i].getNotAfter().toString() + "</notAfter>\n");
                xml.append("    <serial>" + certChain[i].getSerialNumber().toString() + "</serial>\n");
                xml.append("    <sigalg>" + certChain[i].getSigAlgName() + "</sigalg>\n");
                xml.append("    <pem>\n");
                xml.append(SSLConnection.certToPEM(certChain[i]));
                xml.append("    </pem>\n");
                xml.append("  </cert>\n");
            }
        }
        xml.append("</certchain>\n");
        return xml.toString();
    }

    private static String certToPEM(X509Certificate cert) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("-----BEGIN CERTIFICATE-----\n");
        buf.append(DatatypeConverter.printBase64Binary((byte[])cert.getEncoded()).replaceAll("(.{64})", "$1\n"));
        buf.append("\n-----END CERTIFICATE-----\n");
        return buf.toString();
    }

    static /* synthetic */ X509Certificate[] access$002(X509Certificate[] x0) {
        certChain = x0;
        return x0;
    }

    private class VeryTrustingHostNameVerifier
    implements HostnameVerifier {
        private VeryTrustingHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

