/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.Project;
import org.apache.xalan.processor.TransformerFactoryImpl;

public class XSLCache {
    private Project antProject = null;
    private TransformerFactory xformFactory = null;
    private Map<String, Transformer> cache = new HashMap<String, Transformer>();
    private static XSLCache singleton = null;

    private static XSLCache getCache(Project project) throws Exception {
        if (singleton == null) {
            singleton = new XSLCache(project);
        }
        return singleton;
    }

    private XSLCache(Project project) {
        this.xformFactory = new TransformerFactoryImpl();
        this.antProject = project;
    }

    public static Transformer getTransformer(Project project, String xslFilename) throws Exception {
        XSLCache xslcache = XSLCache.getCache(project);
        Transformer ret = xslcache.cache.get(xslFilename);
        if (ret == null) {
            String path = xslcache.antProject.resolveFile(xslFilename).getParent();
            TransformerFactory transFactory = xslcache.xformFactory;
            XSLCache xSLCache = xslcache;
            xSLCache.getClass();
            transFactory.setURIResolver(xSLCache.new DCMResolver(path, xslcache.antProject));
            ret = transFactory.newTransformer(new StreamSource(new FileInputStream(xslFilename)));
            xslcache.cache.put(xslFilename, ret);
        }
        return ret;
    }

    private class DCMResolver
    implements URIResolver {
        private Project antProject = null;
        private String originalPath = "";
        private String basePath = "";
        private String dcmPath = "";
        private String workPath = "";
        private DocumentBuilderFactory dbFactory = null;

        public DCMResolver(String path, Project project) throws Exception {
            this.originalPath = path;
            this.antProject = project;
            this.basePath = this.antProject.getBaseDir().getPath();
            this.dcmPath = this.antProject.getProperty("dcm.dir");
            this.workPath = this.antProject.getProperty("work.dir");
            this.dbFactory = DocumentBuilderFactory.newInstance();
            this.dbFactory.setNamespaceAware(true);
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            try {
                String fullFilename = href;
                File test = new File(href);
                if (!test.isAbsolute()) {
                    if (new File(this.originalPath + "/" + href).exists()) {
                        fullFilename = this.originalPath + "/" + href;
                    } else if (new File(this.basePath + "/" + href).exists()) {
                        fullFilename = this.basePath + "/" + href;
                    } else if (this.dcmPath != null && new File(this.dcmPath + "/" + href).exists()) {
                        fullFilename = this.dcmPath + "/" + href;
                    } else if (this.workPath != null && new File(this.workPath + "/" + href).exists()) {
                        fullFilename = this.workPath + "/" + href;
                    } else {
                        System.out.println("DCMResolver originalPath=" + this.originalPath);
                        System.out.println("DCMResolver basePath=" + this.basePath);
                        System.out.println("DCMResolver dcmPath=" + this.dcmPath);
                        System.out.println("DCMResolver workPath=" + this.workPath);
                        throw new TransformerException("Can't locate " + href);
                    }
                }
                return new DOMSource(this.dbFactory.newDocumentBuilder().parse(new File(fullFilename)));
            }
            catch (Exception e) {
                throw new TransformerException(e);
            }
        }
    }
}

