/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NamedParams {
    private TreeMap<String, String> mapParams;

    public NamedParams() {
        this.mapParams = new TreeMap();
    }

    public NamedParams(String[] params) {
        this.mapParams = new TreeMap();
        this.set(params);
    }

    public NamedParams(NamedParams other) {
        this.mapParams = new TreeMap<String, String>((SortedMap<String, String>)other.mapParams);
    }

    public String get(String paramId) {
        return this.mapParams.get(paramId);
    }

    public void set(String paramId, String paramVal) {
        this.mapParams.put(paramId, paramVal);
    }

    public void set(String[] params) {
        if (params.length % 2 == 1) {
            throw new UnsupportedOperationException("The number of params must be even (multiple of 2) since these are key/value pairs.");
        }
        for (int i = 0; i < params.length; i += 2) {
            this.set(params[i], params[i + 1]);
        }
    }

    public void set(NamedParams other) {
        for (Map.Entry<String, String> entry : other.mapParams.entrySet()) {
            this.mapParams.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.mapParams.clear();
    }

    public void remove(String paramId) {
        this.mapParams.remove(paramId);
    }

    public String[] toStringArray() {
        String[] ret = new String[this.mapParams.size() * 2];
        Iterator<Map.Entry<String, String>> it = this.mapParams.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            ret[i++] = entry.getKey();
            ret[i++] = entry.getValue();
        }
        return ret;
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<String, String> entry : this.mapParams.entrySet()) {
            String key = entry.getKey();
            if (key.equals("pwd")) {
                buf.append(", \n" + entry.getKey() + " = XXXXX");
                continue;
            }
            buf.append(", \n" + entry.getKey() + " = " + entry.getValue());
        }
        String strRet = "";
        if (buf.length() > 0) {
            strRet = buf.substring(", \n".length());
        }
        return strRet;
    }

    public void insistOn(String paramId) throws IllegalArgumentException {
        if (this.get(paramId) == null) {
            throw new IllegalArgumentException("\"" + paramId + "\" is missing from params");
        }
    }

    public void insistOn(String[] paramIds) throws IllegalArgumentException {
        for (int i = 0; i < paramIds.length; ++i) {
            if (this.get(paramIds[i]) != null) continue;
            throw new IllegalArgumentException("\"" + paramIds[i] + "\" is missing from params");
        }
    }

    public void doSubstitutions() {
        Pattern pat = Pattern.compile("(%\\{[a-zA-Z0-9\\.\\-_]+\\})");
        for (Map.Entry<String, String> entry : this.mapParams.entrySet()) {
            String paramId = entry.getKey();
            String paramVal = entry.getValue();
            Matcher matches = pat.matcher(paramVal);
            boolean substitutionsMade = false;
            StringBuffer sb = new StringBuffer();
            while (matches.find()) {
                String substitutionId = matches.group();
                String newValue = this.get(substitutionId = substitutionId.substring(2, substitutionId.length() - 1));
                if (newValue != null) {
                    matches.appendReplacement(sb, newValue);
                    substitutionsMade = true;
                    continue;
                }
                matches.appendReplacement(sb, "%{" + substitutionId + "}");
            }
            if (!substitutionsMade) continue;
            matches.appendTail(sb);
            this.set(paramId, sb.toString());
        }
    }
}

