/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.Base64;
import com.ibm.dcm.NamedParams;
import com.ibm.dcm.SSLConnection;
import com.ibm.dcm.SomaUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Soma {
    private SSLConnection conn;
    private static boolean DEBUG = false;

    public Soma(SSLConnection conn) {
        this.conn = conn;
    }

    public Soma(Soma other) {
        this.conn = other.conn;
    }

    private Soma() {
    }

    public SSLConnection getConnection() {
        return this.conn;
    }

    public NamedParams performOperation(NamedParams params) throws Exception {
        NamedParams result = null;
        params.insistOn("soma");
        String somaOp = params.get("soma");
        if (somaOp.equals("AddKnownHost")) {
            result = this.doAddKnownHost(params);
        } else if (somaOp.equals("AddPasswordMap")) {
            result = this.doAddPasswordMap(params);
        } else if (somaOp.equals("AddTrustedHost")) {
            result = this.doAddTrustedHost(params);
        } else if (somaOp.equals("Backup")) {
            result = this.doBackup(params);
        } else if (somaOp.equals("BackupDevice")) {
            result = this.doBackupDevice(params);
        } else if (somaOp.equals("BootDelete")) {
            result = this.doBootDelete(params);
        } else if (somaOp.equals("BootUpdate")) {
            result = this.doBootUpdate(params);
        } else if (somaOp.equals("CacheSchema")) {
            result = this.doCacheSchema(params);
        } else if (somaOp.equals("CacheStylesheet")) {
            result = this.doCacheStylesheet(params);
        } else if (somaOp.equals("CacheWSDL")) {
            result = this.doCacheWSDL(params);
        } else if (somaOp.equals("ChangePassword")) {
            result = this.doChangePassword(params);
        } else if (somaOp.equals("ClearFilestore")) {
            result = this.doClearFilestore(params);
        } else if (somaOp.equals("ConvertCertificate")) {
            result = this.doConvertCertificate(params);
        } else if (somaOp.equals("ConvertKey")) {
            result = this.doConvertKey(params);
        } else if (somaOp.equals("CpaImport")) {
            result = this.doCpaImport(params);
        } else if (somaOp.equals("CreateDirectory")) {
            result = this.doCreateDirectory(params);
        } else if (somaOp.equals("CreateTAMFiles")) {
            result = this.doCreateTAMFiles(params);
        } else if (somaOp.equals("CryptoExport")) {
            result = this.doCryptoExport(params);
        } else if (somaOp.equals("CryptoImport")) {
            result = this.doCryptoImport(params);
        } else if (somaOp.equals("DeleteConfig")) {
            result = this.doDeleteConfig(params);
        } else if (somaOp.equals("DeleteFile")) {
            result = this.doDeleteFile(params);
        } else if (somaOp.equals("DeleteKnownHost")) {
            result = this.doDeleteKnownHost(params);
        } else if (somaOp.equals("DeleteKnownHostTable")) {
            result = this.doDeleteKnownHostTable(params);
        } else if (somaOp.equals("DeletePasswordMap")) {
            result = this.doDeletePasswordMap(params);
        } else if (somaOp.equals("DeleteTrustedHost")) {
            result = this.doDeleteTrustedHost(params);
        } else if (somaOp.equals("DeviceCertificate")) {
            result = this.doDeviceCertificate(params);
        } else if (somaOp.equals("DisconnectUser")) {
            result = this.doDisconnectUser(params);
        } else if (somaOp.equals("ExecConfig")) {
            result = this.doExecConfig(params);
        } else if (somaOp.equals("ExecCLI")) {
            result = this.doExecCLI(params);
        } else if (somaOp.equals("Export")) {
            result = this.doExport(params);
        } else if (somaOp.equals("FetchFile")) {
            result = this.doFetchFile(params);
        } else if (somaOp.equals("FileCapture")) {
            result = this.doFileCapture(params);
        } else if (somaOp.equals("FirmwareRollback")) {
            result = this.doFirmwareRollback(params);
        } else if (somaOp.equals("FlushAAACache")) {
            result = this.doFlushAAACache(params);
        } else if (somaOp.equals("FlushArpCache")) {
            result = this.doFlushArpCache(params);
        } else if (somaOp.equals("FlushDNSCache")) {
            result = this.doFlushDNSCache(params);
        } else if (somaOp.equals("FlushDocumentCache")) {
            result = this.doFlushDocumentCache(params);
        } else if (somaOp.equals("FlushNDCache")) {
            result = this.doFlushNDCache(params);
        } else if (somaOp.equals("FlushNSSCache")) {
            result = this.doFlushNSSCache(params);
        } else if (somaOp.equals("FlushPDPCache")) {
            result = this.doFlushPDPCache(params);
        } else if (somaOp.equals("FlushRBMCache")) {
            result = this.doFlushRBMCache(params);
        } else if (somaOp.equals("FlushStylesheetCache")) {
            result = this.doFlushStylesheetCache(params);
        } else if (somaOp.equals("GenerateErrorReport")) {
            result = this.doGenerateErrorReport(params);
        } else if (somaOp.equals("GetConfig")) {
            result = this.doGetConfig(params);
        } else if (somaOp.equals("GetConformanceReport")) {
            result = this.doGetConformanceReport(params);
        } else if (somaOp.equals("GetDiff")) {
            result = this.doGetDiff(params);
        } else if (somaOp.equals("GetFile")) {
            result = this.doGetFile(params);
        } else if (somaOp.equals("GetFilestore")) {
            result = this.doGetFilestore(params);
        } else if (somaOp.equals("GetObjectStatus")) {
            result = this.doGetObjectStatus(params);
        } else if (somaOp.equals("GetStatuses")) {
            result = this.doGetStatuses(params);
        } else if (somaOp.equals("GetLog")) {
            result = this.doGetLog(params);
        } else if (somaOp.equals("ImportConfig")) {
            result = this.doImportConfig(params);
        } else if (somaOp.equals("ImportExecute")) {
            result = this.doImportExecute(params);
        } else if (somaOp.equals("IsUp")) {
            result = this.doIsUp(params);
        } else if (somaOp.equals("Keygen")) {
            result = this.doKeygen(params);
        } else if (somaOp.equals("LocateDevice")) {
            result = this.doLocateDevice(params);
        } else if (somaOp.equals("MemoryStatus")) {
            result = this.doMemoryStatus(params);
        } else if (somaOp.equals("ModifyConfig")) {
            result = this.doModifyConfig(params);
        } else if (somaOp.equals("MoveFile")) {
            result = this.doMoveFile(params);
        } else if (somaOp.equals("NoPasswordMap")) {
            result = this.doNoPasswordMap(params);
        } else if (somaOp.equals("PasswordMap")) {
            result = this.doPasswordMap(params);
        } else if (somaOp.equals("Ping")) {
            result = this.doPing(params);
        } else if (somaOp.equals("QuiesceDevice")) {
            result = this.doQuiesceDevice(params);
        } else if (somaOp.equals("QuiesceDomain")) {
            result = this.doQuiesceDomain(params);
        } else if (somaOp.equals("QuiesceFSH")) {
            result = this.doQuiesceFSH(params);
        } else if (somaOp.equals("QuiesceService")) {
            result = this.doQuiesceService(params);
        } else if (somaOp.equals("RawMgmtCall")) {
            result = this.doRawMgmtCall(params);
        } else if (somaOp.equals("RefreshDocument")) {
            result = this.doRefreshDocument(params);
        } else if (somaOp.equals("RefreshStylesheet")) {
            result = this.doRefreshStylesheet(params);
        } else if (somaOp.equals("RefreshTAMCerts")) {
            result = this.doRefreshTAMCerts(params);
        } else if (somaOp.equals("RemoveCheckpoint")) {
            result = this.doRemoveCheckpoint(params);
        } else if (somaOp.equals("RemoveDirectory")) {
            result = this.doRemoveDirectory(params);
        } else if (somaOp.equals("RemoveStylesheet")) {
            result = this.doRemoveStylesheet(params);
        } else if (somaOp.equals("ResetDomain")) {
            result = this.doResetDomain(params);
        } else if (somaOp.equals("RestartDomain")) {
            result = this.doRestartDomain(params);
        } else if (somaOp.equals("Restore")) {
            result = this.doRestore(params);
        } else if (somaOp.equals("RollbackCheckpoint")) {
            result = this.doRollbackCheckpoint(params);
        } else if (somaOp.equals("SaveCheckpoint")) {
            result = this.doSaveCheckpoint(params);
        } else if (somaOp.equals("SaveConfig")) {
            result = this.doSaveConfig(params);
        } else if (somaOp.equals("SecureBackup")) {
            result = this.doSecureBackup(params);
        } else if (somaOp.equals("SecureRestore")) {
            result = this.doSecureRestore(params);
        } else if (somaOp.equals("SelectConfig")) {
            result = this.doSelectConfig(params);
        } else if (somaOp.equals("SendErrorReport")) {
            result = this.doSendErrorReport(params);
        } else if (somaOp.equals("SendFile")) {
            result = this.doSendFile(params);
        } else if (somaOp.equals("SendLogEvent")) {
            result = this.doSendLogEvent(params);
        } else if (somaOp.equals("SetConfig")) {
            result = this.doSetConfig(params);
        } else if (somaOp.equals("SetFile")) {
            result = this.doSetFile(params);
        } else if (somaOp.equals("SetLogLevel")) {
            result = this.doSetLogLevel(params);
        } else if (somaOp.equals("SetRBMLogLevel")) {
            result = this.doSetRBMLogLevel(params);
        } else if (somaOp.equals("SetSystemVar")) {
            result = this.doSetSystemVar(params);
        } else if (somaOp.equals("SetTimeAndDate")) {
            result = this.doSetTimeAndDate(params);
        } else if (somaOp.equals("Shutdown")) {
            result = this.doShutdown(params);
        } else if (somaOp.equals("TCPConnectionTest")) {
            result = this.doTCPConnectionTest(params);
        } else if (somaOp.equals("TestPasswordMap")) {
            result = this.doTestPasswordMap(params);
        } else if (somaOp.equals("TestURLMap")) {
            result = this.doTestURLMap(params);
        } else if (somaOp.equals("TestURLRefresh")) {
            result = this.doTestURLRefresh(params);
        } else if (somaOp.equals("TestURLRewrite")) {
            result = this.doTestURLRewrite(params);
        } else if (somaOp.equals("TestValidateSchema")) {
            result = this.doTestValidateSchema(params);
        } else if (somaOp.equals("UndoConfig")) {
            result = this.doUndoConfig(params);
        } else if (somaOp.equals("UniversalPacketCaptureDebug")) {
            result = this.doUniversalPacketCaptureDebug(params);
        } else if (somaOp.equals("UniversalStopPacketCapture")) {
            result = this.doUniversalStopPacketCapture(params);
        } else if (somaOp.equals("UnquiesceDevice")) {
            result = this.doUnquiesceDevice(params);
        } else if (somaOp.equals("UnquiesceDomain")) {
            result = this.doUnquiesceDomain(params);
        } else if (somaOp.equals("UnquiesceFSH")) {
            result = this.doUnquiesceFSH(params);
        } else if (somaOp.equals("UnquiesceService")) {
            result = this.doUnquiesceService(params);
        } else if (somaOp.equals("Upload")) {
            result = this.doUpload(params);
        } else if (somaOp.equals("UserForcePasswordChange")) {
            result = this.doUserForcePasswordChange(params);
        } else if (somaOp.equals("UserResetFailedLogin")) {
            result = this.doUserResetFailedLogin(params);
        } else if (somaOp.equals("UserResetPassword")) {
            result = this.doUserResetPassword(params);
        } else if (somaOp.equals("ValCredAddCertsFromDir")) {
            result = this.doValCredAddCertsFromDir(params);
        } else if (somaOp.equals("WSRRSynchronize")) {
            result = this.doWSRRSynchronize(params);
        } else {
            throw new UnsupportedOperationException("soma=" + somaOp + " is not a recognized SOMA operation.");
        }
        return result;
    }

    private static void debug(String msg) {
        if (DEBUG) {
            System.out.println("[debug] Soma: " + msg);
        }
    }

    public NamedParams doRawMgmtCall(NamedParams params) throws Exception {
        params.insistOn(new String[]{"request", "response"});
        File requestFile = new File(params.get("request"));
        Soma.debug("requestFile: " + requestFile.getAbsolutePath());
        String request = Soma.readFile(requestFile);
        NamedParams result = params;
        result = this.conn.sendAndReceive(params, request, params.get("method"));
        String raw = result.get("rawresponse");
        File responseFile = new File(params.get("response"));
        Soma.debug("responseFile: " + responseFile.getAbsolutePath());
        PrintWriter out = new PrintWriter(responseFile);
        out.println(raw);
        out.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public NamedParams doAddKnownHost(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "clientname", "knownhost", "key"});
        StringBuffer body = new StringBuffer();
        body.append("<AddKnownHost>");
        body.append("<ClientName>" + params.get("clientname") + "</ClientName>");
        body.append("<Host>" + params.get("knownhost") + "</Host>");
        if (params.get("type") != null) {
            body.append("<Type>" + params.get("type") + "</Type>");
        } else {
            body.append("<Type>ssh-rsa</Type>");
        }
        body.append("<Key>" + params.get("key") + "</Key>");
        body.append("</AddKnownHost>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doAddPasswordMap(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "aliasname", "type"});
        StringBuffer body = new StringBuffer();
        body.append("<AddPasswordMap>");
        body.append("<AliasName>" + params.get("aliasname") + "</AliasName>");
        body.append("<Type>" + params.get("type") + "</Type>");
        body.append("</AddPasswordMap>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doAddTrustedHost(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "trustedhost", "key"});
        StringBuffer body = new StringBuffer();
        body.append("<AddTrustedHost>");
        body.append("<Host>" + params.get("trustedhost") + "</Host>");
        if (params.get("type") != null) {
            body.append("<Type>" + params.get("type") + "</Type>");
        } else {
            body.append("<Type>ssh-rsa</Type>");
        }
        body.append("<Key>" + params.get("key") + "</Key>");
        body.append("</AddTrustedHost>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NamedParams doBackup(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "local"});
        StringBuffer body = new StringBuffer();
        body.append("<soma:do-backup");
        if (params.get("format") != null) {
            body.append(" format=\"" + params.get("format") + "\"");
        } else {
            body.append(" format=\"ZIP\"");
        }
        if (params.get("persisted") != null) {
            body.append(" persisted=\"" + params.get("persisted") + "\"");
        } else {
            body.append(" persisted=\"false\"");
        }
        if (params.get("deployment-policy-name") != null) {
            body.append(" deployment-policy=\"" + params.get("deployment-policy-name") + "\"");
        }
        body.append(">");
        if (params.get("user-comment") != null) {
            body.append("<soma:user-comment>" + params.get("user-comment") + "</soma:user-comment>");
        }
        body.append("<soma:domain name=\"" + params.get("domain") + "\"/>");
        if (params.get("domains") != null) {
            String[] names = params.get("domains").split("[ ,]+");
            for (int i = 0; i < names.length; ++i) {
                if (names[i].equals(params.get("domain"))) continue;
                body.append("<soma:domain name=\"" + names[i] + "\"/>");
            }
        }
        if (params.get("deployment-policy") != null) {
            body.append("<soma:deployment-policy>" + params.get("deployment-policy") + "</soma:deployment-policy>");
        }
        body.append("</soma:do-backup>");
        String request = SomaUtils.getGeneralEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            String contentBase64 = SomaUtils.stringXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:file");
            if (contentBase64.length() <= 0) throw new RuntimeException("Failed to backup on " + params.get("hostname"));
            Base64.base64ToBinaryFile(contentBase64, params.get("local"));
            return result;
        }
        try {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            String contentBase64 = SomaUtils.stringXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:file");
            if (contentBase64.length() <= 0) return result;
            Base64.base64ToBinaryFile(contentBase64, params.get("local"));
            return result;
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public NamedParams doBackupDevice(NamedParams params) throws Exception {
        params.insistOn(new String[]{"local"});
        NamedParams getdomains = new NamedParams(params);
        getdomains.set("statuses", "DomainStatus");
        getdomains.set("domain", "default");
        NamedParams domainstatuses = this.doGetStatuses(getdomains);
        StringBuffer domains = new StringBuffer();
        Node root = SomaUtils.getDOM(domainstatuses.get("status"));
        NodeList listDomains = SomaUtils.nodelistXpathFor(root, "/status/DomainStatus/Domain");
        if (listDomains != null) {
            for (int i = 0; i < listDomains.getLength(); ++i) {
                String domainname = listDomains.item(i).getTextContent();
                if (domainname.equals("default")) continue;
                if (i > 0) {
                    domains.append(" ");
                }
                domains.append(domainname);
            }
        } else if (this.errorsAreSignificant(params)) {
            throw new RuntimeException("Failed to get the list of domains on " + params.get("hostname") + " for some reason!");
        }
        params.set("domains", domains.toString());
        params.set("domain", "default");
        return this.doBackup(params);
    }

    public NamedParams doBootDelete(NamedParams params) throws Exception {
        String body = "<BootDelete/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doBootUpdate(NamedParams params) throws Exception {
        StringBuffer body = new StringBuffer();
        body.append("<BootUpdate>");
        if (params.get("option") != null) {
            body.append("<option>" + params.get("option") + "</option>");
        }
        body.append("<File>" + params.get("name") + "</File>");
        body.append("</BootUpdate>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCacheSchema(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "url"});
        StringBuffer body = new StringBuffer();
        body.append("<CacheSchema>");
        body.append("<XMLManager>" + params.get("objname") + "</XMLManager>");
        body.append("<URL>" + params.get("url") + "</URL>");
        if (params.get("mode") != null) {
            body.append("<Mode>" + params.get("mode") + "</Mode>");
        }
        body.append("</CacheSchema>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCacheStylesheet(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "url"});
        StringBuffer body = new StringBuffer();
        body.append("<CacheStylesheet>");
        body.append("<XMLManager>" + params.get("objname") + "</XMLManager>");
        body.append("<URL>" + params.get("url") + "</URL>");
        if (params.get("mode") != null) {
            body.append("<Mode>" + params.get("mode") + "</Mode>");
        }
        body.append("</CacheStylesheet>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCacheWSDL(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "url"});
        String body = "<CacheWSDL><XMLManager>" + params.get("objname") + "</XMLManager>" + "<URL>" + params.get("url") + "</URL>" + "</CacheWSDL>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doChangePassword(NamedParams params) throws Exception {
        params.insistOn(new String[]{"pwd", "newpwd"});
        String body = "<ChangePassword><OldPassword>" + params.get("pwd") + "</OldPassword>" + "<Password>" + params.get("newpwd") + "</Password>" + "</ChangePassword>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doClearFilestore(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "filestore"});
        if (params.get("domain").equals("default")) {
            if (this.errorsAreSignificant(params)) {
                throw new RuntimeException("ClearFilestore is not permitted in the default domain since it affects all domains on the device, and as such is considered too dangerous to permit.");
            }
            return params;
        }
        String fs = params.get("filestore");
        if (!(fs.equals("cert:") || fs.equals("export:") || fs.equals("local:") || fs.equals("logstore:") || fs.equals("logtemp:") || fs.equals("sharedcert:") || fs.equals("temporary:"))) {
            if (this.errorsAreSignificant(params)) {
                throw new RuntimeException("Filestore \"" + fs + "\" isn't permitted to be cleared.");
            }
            return params;
        }
        NamedParams fsResult = this.doGetFilestore(params);
        String location = fsResult.get("location");
        if (location != null && location.length() > 0) {
            Node nodeLocation = SomaUtils.getDOM(fsResult.get("location"));
            fsResult = null;
            if (nodeLocation != null) {
                Vector<String> dirnames = new Vector<String>();
                this.extractDirectoryNames(nodeLocation, dirnames);
                for (int i = 0; i < dirnames.size(); ++i) {
                    String dirname = dirnames.get(i);
                    String remoteDirname = fs + "///" + dirname;
                    System.out.println("Delete directory " + remoteDirname);
                    NamedParams p = new NamedParams(params);
                    p.set("remote", remoteDirname);
                    p.set("ignore-errors", "true");
                    this.doRemoveDirectory(p);
                }
                for (Node kid = nodeLocation.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                    if (kid.getNodeType() != 1 || !kid.getNodeName().equals("file")) continue;
                    String filename = fs + "///" + ((Element)kid).getAttribute("name");
                    System.out.println("Delete file " + filename);
                    NamedParams p = new NamedParams(params);
                    p.set("remote", filename);
                    this.doDeleteFile(p);
                }
            }
        }
        return params;
    }

    private void extractDirectoryNames(Node node, Vector<String> dirnames) {
        if (node.getNodeType() == 1) {
            Element el = (Element)node;
            for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 1) continue;
                this.extractDirectoryNames(kid, dirnames);
            }
            if (el.getNodeName().equals("directory")) {
                String dirname = ((Element)node).getAttribute("name");
                int i = dirname.indexOf(":/");
                if (i > 0) {
                    dirname = dirname.substring(i + ":/".length());
                }
                dirnames.add(dirname);
            }
        }
    }

    public NamedParams doConvertCertificate(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<ConvertCertificate>");
        body.append("<ObjectName>" + params.get("objname") + "</ObjectName>");
        body.append("<OutputFilename>" + params.get("remote") + "</OutputFilename>");
        if (params.get("format") != null) {
            body.append("<Format>" + params.get("format") + "</Format>");
        } else {
            body.append("<Format>openssh-pubkey</Format>");
        }
        body.append("</ConvertCertificate>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doConvertKey(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<ConvertKey>");
        body.append("<ObjectName>" + params.get("objname") + "</ObjectName>");
        body.append("<OutputFilename>" + params.get("remote") + "</OutputFilename>");
        if (params.get("format") != null) {
            body.append("<Format>" + params.get("format") + "</Format>");
        } else {
            body.append("<Format>openssh-pubkey</Format>");
        }
        body.append("</ConvertKey>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCpaImport(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "local", "gateway-name", "internal-party"});
        StringBuffer body = new StringBuffer();
        body.append("<soma:do-cpa-import>");
        body.append("<input-file>" + params.get("local") + "</input-file>");
        body.append("<gateway-name>" + params.get("gateway-name") + "</gateway-name>");
        body.append("<internal-party>" + params.get("internal-party") + "</internal-party>");
        if (params.get("overwrite-files") != null) {
            body.append(" overwrite-files=\"" + params.get("overwrite-files") + "\"");
        } else {
            body.append(" overwrite-files=\"true\"");
        }
        if (params.get("overwrite-files") != null) {
            body.append(" overwrite-objects=\"" + params.get("overwrite-objects") + "\"");
        } else {
            body.append(" overwrite-objects=\"true\"");
        }
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCreateDirectory(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "remote"});
        String body = "<CreateDir><Dir>" + params.get("remote") + "</Dir>" + "</CreateDir>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCreateTAMFiles(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "outputconfigfile", "administrator-uid", "administrator-pwd", "tamdomain", "application", "tamhost", "tamport", "sslkeyfilelifetime", "ssltimeout", "localmode", "useadregistry"});
        StringBuffer body = new StringBuffer();
        body.append("<CreateTAMFiles>");
        if (params.get("createcopy") != null) {
            body.append("<CreateCopy>" + params.get("createcopy") + "</CreateCopy>");
        }
        body.append("<OutputConfigFile>" + params.get("outputconfigfile") + "</OutputConfigFile>");
        body.append("<Administrator>" + params.get("administrator-uid") + "</Administrator>");
        body.append("<Password>" + params.get("administrator-pwd") + "</Password>");
        body.append("<TAMDomain>" + params.get("tamdomain") + "</TAMDomain>");
        body.append("<Application>" + params.get("application") + "</Application>");
        body.append("<Host>" + params.get("tamhost") + "</Host>");
        body.append("<Port>" + params.get("tamport") + "</Port>");
        body.append("<SSLKeyFileLifetime>" + params.get("sslkeyfilelifetime") + "</SSLKeyFileLifetime>");
        body.append("<SSLTimeout>" + params.get("ssltimeout") + "</SSLTimeout>");
        body.append("<LocalMode>" + params.get("localmode") + "</LocalMode>");
        if (params.get("listenmode") != null) {
            body.append("<ListenMode>" + params.get("listenmode") + "</ListenMode>");
        }
        if (params.get("localhost") != null) {
            body.append("<LocalHost>" + params.get("localhost") + "</LocalHost>");
        }
        if (params.get("localport") != null) {
            body.append("<LocalPort>" + params.get("localport") + "</LocalPort>");
        }
        body.append("<UseADRegistry>" + params.get("useadregistry") + "</UseADRegistry>");
        if (params.get("adpprimarydomain") != null) {
            body.append("<ADPrimaryDomain>" + params.get("adpprimarydomain") + "</ADPrimaryDomain>");
        }
        if (params.get("adpprimaryhost") != null) {
            body.append("<ADPrimaryHost>" + params.get("adpprimaryhost") + "</ADPrimaryHost>");
        }
        if (params.get("adpprimaryreplicas") != null) {
            body.append("<ADPrimaryReplicas>" + params.get("adpprimaryreplicas") + "</ADPrimaryReplicas>");
        }
        if (params.get("ldapserver") != null) {
            body.append("<LDAPServer>" + params.get("ldapserver") + "</LDAPServer>");
        }
        if (params.get("ldapport") != null) {
            body.append("<LDAPPort>" + params.get("ldapport") + "</LDAPPort>");
        }
        if (params.get("ldapbindpassword") != null) {
            body.append("<LDAPBindPassword>" + params.get("ldapbindpassword") + "</LDAPBindPassword>");
        }
        if (params.get("ldapauthtimeout") != null) {
            body.append("<LDAPAuthenticateTimeout>" + params.get("ldapauthtimeout") + "</LDAPAuthenticateTimeout>");
        }
        if (params.get("ldapsearchtimeout") != null) {
            body.append("<LDAPSearchTimeout>" + params.get("ldapsearchtimeout") + "</LDAPSearchTimeout>");
        }
        if (params.get("adpclienttimeout") != null) {
            body.append("<ADClientTimeout>" + params.get("adpclienttimeout") + "</ADClientTimeout>");
        }
        if (params.get("enableregistrycache") != null) {
            body.append("<EnableRegistryCache>" + params.get("enableregistrycache") + "</EnableRegistryCache>");
        }
        if (params.get("ldapusercachesize") != null) {
            body.append("<LDAPUserCacheSize>" + params.get("ldapusercachesize") + "</LDAPUserCacheSize>");
        }
        if (params.get("ldappolicycachesize") != null) {
            body.append("<LDAPPolicyCacheSize>" + params.get("ldappolicycachesize") + "</LDAPPolicyCacheSize>");
        }
        if (params.get("adldapcachesize") != null) {
            body.append("<ADLdapCacheSize>" + params.get("adldapcachesize") + "</ADLdapCacheSize>");
        }
        if (params.get("adldapcachelife") != null) {
            body.append("<ADLdapCacheLife>" + params.get("adldapcachelife") + "</ADLdapCacheLife>");
        }
        if (params.get("addnforpd") != null) {
            body.append("<ADDnforpd>" + params.get("addnforpd") + "</ADDnforpd>");
        }
        if (params.get("adusemultidomain") != null) {
            body.append("<ADUseMultiDomain>" + params.get("adusemultidomain") + "</ADUseMultiDomain>");
        }
        if (params.get("addomaindomain") != null) {
            body.append("<ADDomaindomain>" + params.get("addomaindomain") + "</ADDomaindomain>");
        }
        if (params.get("addomainhost") != null) {
            body.append("<ADDomainHost>" + params.get("addomainhost") + "</ADDomainHost>");
        }
        if (params.get("addomainreplicas") != null) {
            body.append("<ADDomainReplicas>" + params.get("addomainreplicas") + "</ADDomainReplicas>");
        }
        if (params.get("aduseemailuid") != null) {
            body.append("<ADUseEmailUid>" + params.get("aduseemailuid") + "</ADUseEmailUid>");
        }
        if (params.get("adgchost") != null) {
            body.append("<ADGcHost>" + params.get("adgchost") + "</ADGcHost>");
        }
        body.append("</CreateTAMFiles>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCryptoExport(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<CryptoExport>");
        if (params.get("objtype") != null) {
            body.append("<ObjectType>" + params.get("objtype") + "</ObjectType>");
        }
        body.append("<ObjectName>" + params.get("name") + "</ObjectName>");
        body.append("<OutputFilename>" + params.get("remote") + "</OutputFilename>");
        if (params.get("mechanism") != null) {
            body.append("<Mechanism>" + params.get("mechanism") + "</Mechanism>");
        }
        body.append("</CryptoExport>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doCryptoImport(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<CryptoImport>");
        if (params.get("objtype") != null) {
            body.append("<ObjectType>" + params.get("objtype") + "</ObjectType>");
        }
        body.append("<ObjectName>" + params.get("name") + "</ObjectName>");
        body.append("<InputFilename>" + params.get("remote") + "</InputFilename>");
        if (params.get("password") != null) {
            body.append("<ImportPassword>" + params.get("password") + "</ImportPassword>");
        }
        if (params.get("passwordalias") != null) {
            body.append("<ImportPasswordAlias>" + params.get("passwordalias") + "</ImportPasswordAlias>");
        }
        if (params.get("kwkexportable") != null) {
            body.append("<KwkExportable>" + params.get("kwkexportable") + "</KwkExportable>");
        }
        body.append("</CryptoImport>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doDeleteConfig(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        StringBuffer body = new StringBuffer("<soma:del-config>");
        if (params.get("classname") != null && params.get("objname") != null) {
            body.append("<" + params.get("classname") + " name=\"" + params.get("objname") + "\"/>");
        } else if (params.get("config") != null) {
            body.append(SomaUtils.xmlNoHeader(params.get("config")));
        } else {
            throw new RuntimeException("Either 'config' must be specified or 'classname' plus 'objname' must be specified.");
        }
        body.append("</soma:del-config>");
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        try {
            result = this.conn.sendAndReceive(params, request);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public NamedParams doDeleteFile(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "remote"});
        String body = "<DeleteFile><File>" + params.get("remote") + "</File></DeleteFile>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doDeleteKnownHost(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "knownhost"});
        StringBuffer body = new StringBuffer();
        body.append("<DeleteKnownHost>");
        body.append("<ClientName>" + params.get("clientname") + "</ClientName>");
        body.append("<Host>" + params.get("knownhost") + "</Host>");
        body.append("</DeleteKnownHost>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doDeleteKnownHostTable(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "clientname"});
        StringBuffer body = new StringBuffer();
        body.append("<DeleteKnownHostTable>");
        body.append("<DomainName>" + params.get("domain") + "</DomainName>");
        body.append("<ClientName>" + params.get("clientname") + "</ClientName>");
        body.append("</DeleteKnownHostTable>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doDeletePasswordMap(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "aliasname"});
        StringBuffer body = new StringBuffer();
        body.append("<DeletePasswordMap>");
        body.append("<AliasName>" + params.get("aliasname") + "</AliasName>");
        body.append("</DeletePasswordMap>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doDeleteTrustedHost(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "trustedhost"});
        StringBuffer body = new StringBuffer();
        body.append("<DeleteTrustedHost>");
        body.append("<Host>" + params.get("trustedhost") + "</Host>");
        body.append("</DeleteTrustedHost>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doDeviceCertificate(NamedParams params) throws Exception {
        params.insistOn(new String[]{"host"});
        String body = "<DeviceCertificate><CN>" + params.get("host") + "</CN>" + "<SSCert>on</SSCert>" + "</DeviceCertificate>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doDisconnectUser(NamedParams params) throws Exception {
        params.insistOn(new String[]{"sessionid"});
        StringBuffer body = new StringBuffer();
        body.append("<Disconnect>");
        body.append("<id>" + params.get("sessionid") + "</id>");
        if (params.get("sessiontype") != null) {
            body.append("<connection>" + params.get("sessiontype") + "</connection>");
        }
        body.append("</Disconnect>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doExecCLI(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "cli"});
        String filename = new Integer(new Random().nextInt(1000000000) + 1000000000).toString();
        String remoteFilename = "temporary:///ExecCli_" + filename + ".cli";
        NamedParams myParams = new NamedParams(params);
        myParams.set("remote", remoteFilename);
        String base64CLI = Base64.bytesToString(Base64.toBase64(params.get("cli").getBytes(), null));
        NamedParams result = this.doSetFileImpl(myParams, base64CLI);
        String body = "<ExecConfig><URL>" + remoteFilename + "</URL></ExecConfig>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        result = this.conn.sendAndReceive(params, request);
        this.doDeleteFile(myParams);
        if (this.errorsAreSignificant(params)) {
            this.insistSomaResultIsOkay(result);
        }
        return result;
    }

    public NamedParams doExecConfig(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "remote"});
        String body = "<ExecConfig><URL>" + params.get("remote") + "</URL></ExecConfig>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NamedParams doExport(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "local"});
        StringBuffer body = new StringBuffer();
        body.append("<soma:do-export");
        if (params.get("format") != null) {
            body.append(" format=\"" + params.get("format") + "\"");
        } else {
            body.append(" format=\"ZIP\"");
        }
        if (params.get("all-files") != null) {
            body.append(" all-files=\"" + params.get("all-files") + "\"");
        } else {
            body.append(" all-files=\"false\"");
        }
        if (params.get("persisted") != null) {
            body.append(" persisted=\"" + params.get("persisted") + "\"");
        } else {
            body.append(" persisted=\"false\"");
        }
        if (params.get("deployment-policy-name") != null && params.get("deployment-policy-name").length() > 0) {
            body.append(" deployment-policy=\"" + params.get("deployment-policy-name") + "\"");
        }
        body.append(">");
        if (params.get("user-comment") != null && params.get("user-comment").length() > 0) {
            body.append("<user-comment>" + params.get("user-comment") + "</user-comment>");
        }
        if (params.get("objects") != null && params.get("objects").length() > 0) {
            body.append(params.get("objects"));
        } else {
            body.append("<soma:object class=\"all-classes\" name=\"all-objects\" ref-objects=\"true\" ref-files=\"true\"/>");
        }
        if (params.get("deployment-policy") != null && params.get("deployment-policy").length() > 0) {
            body.append(params.get("deployment-policy"));
        }
        body.append("</soma:do-export>");
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            String contentBase64 = SomaUtils.stringXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:file");
            if (contentBase64.length() <= 0) throw new RuntimeException("Failed to export from domain " + params.get("domain") + " on " + params.get("hostname"));
            Base64.base64ToBinaryFile(contentBase64, params.get("local"));
            return result;
        }
        try {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            String contentBase64 = SomaUtils.stringXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:file");
            if (contentBase64.length() <= 0) return result;
            Base64.base64ToBinaryFile(contentBase64, params.get("local"));
            return result;
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public NamedParams doFetchFile(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "url", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<FetchFile>");
        body.append("<URL>" + params.get("url") + "</URL>");
        body.append("<File>" + params.get("remote") + "</File>");
        if (params.get("overwrite") != null) {
            body.append("<Overwrite>" + params.get("overwrite") + "</Overwrite>");
        }
        if (params.get("xmlmanager") != null) {
            body.append("<XMLManager>" + params.get("xmlmanager") + "</XMLManager>");
        }
        body.append("</FetchFile>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFileCapture(NamedParams params) throws Exception {
        params.insistOn(new String[]{"tracingmode"});
        String body = "<FileCapture><Mode>" + params.get("tracingmode") + "</Mode></FileCapture>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFirmwareRollback(NamedParams params) throws Exception {
        String body = "<BootSwitch/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushAAACache(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "policy"});
        String body = "<FlushAAACache><PolicyName>" + params.get("policy") + "</PolicyName></FlushAAACache>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushArpCache(NamedParams params) throws Exception {
        String body = "<FlushArpCache/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushDNSCache(NamedParams params) throws Exception {
        String body = "<FlushDNSCache/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushDocumentCache(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        String xmlManager = params.get("xmlmanager");
        if (xmlManager == null || xmlManager.trim().length() == 0) {
            xmlManager = "default";
        }
        String body = "<FlushDocumentCache><XMLManager>" + xmlManager + "</XMLManager></FlushDocumentCache>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushNDCache(NamedParams params) throws Exception {
        String body = "<FlushNDCache/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushNSSCache(NamedParams params) throws Exception {
        params.insistOn(new String[]{"client"});
        StringBuffer body = new StringBuffer();
        body.append("<FlushNSSCache>");
        body.append("<ZosNSSClient>" + params.get("client") + "</ZosNSSClient>");
        body.append("</FlushNSSCache>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushPDPCache(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name"});
        String body = "<FlushPDPCache><XACMLPDP>" + params.get("name") + "</XACMLPDP></FlushPDPCache>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushRBMCache(NamedParams params) throws Exception {
        String body = "<FlushRBMCache/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doFlushStylesheetCache(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        String xmlManager = params.get("xmlmanager");
        if (xmlManager == null || xmlManager.trim().length() == 0) {
            xmlManager = "default";
        }
        String body = "<FlushStylesheetCache><XMLManager>" + xmlManager + "</XMLManager></FlushStylesheetCache>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doGenerateErrorReport(NamedParams params) throws Exception {
        String body = "<ErrorReport/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doGetConfig(NamedParams params) throws Exception {
        NodeList children;
        params.insistOn("domain");
        StringBuffer body = new StringBuffer();
        body.append("<soma:get-config");
        if (params.get("classname") != null) {
            body.append(" class=\"" + params.get("classname") + "\"");
        }
        if (params.get("objname") != null) {
            body.append(" name=\"" + params.get("objname") + "\"");
        }
        if (params.get("recursive") != null) {
            body.append(" recursive=\"" + params.get("recursive") + "\"");
        } else {
            body.append(" recursive=\"false\"");
        }
        if (params.get("persisted") != null) {
            body.append(" persisted=\"" + params.get("persisted") + "\"");
        } else {
            body.append(" persisted=\"false\"");
        }
        body.append("/>");
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body.toString());
        NamedParams result = this.conn.sendAndReceive(params, request);
        Node root = SomaUtils.getDOM(result.get("rawresponse"));
        Node nodeConfig = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:config");
        boolean throwException = true;
        if (nodeConfig != null && (children = SomaUtils.nodelistXpathFor(nodeConfig, "*")) != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<objs>");
            for (int i = 0; i < children.getLength(); ++i) {
                buf.append(SomaUtils.xmlNoHeader(SomaUtils.serializeXML(children.item(i))));
            }
            buf.append("</objs>");
            result.set("config", buf.toString());
            throwException = false;
        }
        if (throwException && this.errorsAreSignificant(params)) {
            throw new UnsupportedOperationException(result.get("rawresponse"));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NamedParams doGetConformanceReport(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "class", "name", "profile"});
        StringBuffer body = new StringBuffer();
        body.append("<soma:get-conformance-report");
        body.append(" class=\"" + params.get("class") + "\"");
        body.append(" name=\"" + params.get("name") + "\"");
        body.append(" profile=\"" + params.get("profile") + "\"");
        body.append("/>");
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            Node nodeContent = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:conformance-report");
            if (nodeContent == null) throw new RuntimeException("Failed to compute the requested conformance report.");
            result.set("report", SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nodeContent)));
            return result;
        }
        try {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            Node nodeContent = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:conformance-report");
            if (nodeContent == null) return result;
            result.set("report", SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nodeContent)));
            return result;
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NamedParams doGetDiff(NamedParams params) throws Exception {
        params.insistOn("domain");
        StringBuffer body = new StringBuffer();
        body.append("<soma:get-diff>");
        if (params.get("class") == null || params.get("name") == null) {
            body.append("<soma:from>");
            if (params.get("from-export") != null) {
                body.append("<soma:export>" + Base64.base64FromBinaryFile(params.get("from-export")) + "</soma:export>");
            } else if (params.get("from-backup") != null) {
                body.append("<soma:backup>" + Base64.base64FromBinaryFile(params.get("from-backup")) + "</soma:backup>");
            } else {
                if (params.get("from-class") == null) throw new RuntimeException("doGetDiff() requires one of from-export, from-backup, or from-class.");
                body.append("<soma:object");
                body.append(" class=\"" + params.get("from-class") + "\"");
                if (params.get("from-name") == null) {
                    throw new RuntimeException("doGetDiff() - the from-class parameter requires the from-name parameter too.");
                }
                body.append(" name=\"" + params.get("from-name") + "\"");
                if (params.get("from-recursive") != null) {
                    body.append(" recursive=\"" + params.get("from-recursive") + "\"");
                }
                if (params.get("from-persisted") != null) {
                    body.append(" persisted=\"" + params.get("from-persisted") + "\"");
                }
                body.append("/>");
            }
            body.append("</soma:from>");
            body.append("<soma:to>");
            if (params.get("to-export") != null) {
                body.append("<soma:export>" + Base64.base64FromBinaryFile(params.get("to-export")) + "</soma:export>");
            } else if (params.get("to-backup") != null) {
                body.append("<soma:backup>" + Base64.base64FromBinaryFile(params.get("to-backup")) + "</soma:backup>");
            } else {
                if (params.get("to-class") == null) throw new RuntimeException("doGetDiff() requires one of to-export, to-backup, or to-class.");
                body.append("<soma:object");
                body.append(" class=\"" + params.get("to-class") + "\"");
                if (params.get("to-name") == null) {
                    throw new RuntimeException("doGetDiff() - the to-class parameter requires the to-name parameter too.");
                }
                body.append(" name=\"" + params.get("to-name") + "\"");
                if (params.get("to-recursive") != null) {
                    body.append(" recursive=\"" + params.get("to-recursive") + "\"");
                }
                if (params.get("to-persisted") != null) {
                    body.append(" persisted=\"" + params.get("to-persisted") + "\"");
                }
                body.append("/>");
            }
            body.append("</soma:to>");
        } else {
            body.append("<soma:object");
            body.append(" class=\"" + params.get("class") + "\"");
            if (params.get("name") == null) {
                throw new RuntimeException("doGetDiff() - the class parameter requires the name parameter too.");
            }
            body.append(" name=\"" + params.get("name") + "\"");
            if (params.get("recursive") != null) {
                body.append(" recursive=\"" + params.get("recursive") + "\"");
            }
            if (params.get("from-persisted") != null) {
                body.append(" from-persisted=\"" + params.get("from-persisted") + "\"");
            }
            if (params.get("to-persisted") != null) {
                body.append(" to-persisted=\"" + params.get("to-persisted") + "\"");
            }
            body.append("/>");
        }
        body.append("</soma:get-diff>");
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            Node nodeContent = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:diff");
            if (nodeContent == null) throw new RuntimeException("Failed to compute the requested diff.");
            result.set("diff", SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nodeContent)));
            return result;
        }
        try {
            result = this.conn.sendAndReceive(params, request);
            Node root = SomaUtils.getDOM(result.get("rawresponse"));
            Node nodeContent = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:diff");
            if (nodeContent == null) return result;
            result.set("diff", SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nodeContent)));
            return result;
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public NamedParams doGetFile(NamedParams params) throws Exception {
        String content;
        NamedParams result;
        block4: {
            params.insistOn(new String[]{"domain", "local", "remote"});
            String body = "<soma:get-file name=\"" + params.get("remote") + "\"/>";
            String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
            result = params;
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                if (!this.errorsAreSignificant(params)) break block4;
                throw e;
            }
        }
        Node root = SomaUtils.getDOM(result.get("rawresponse"));
        Node nodeContent = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:file");
        boolean throwException = true;
        if (nodeContent != null && (content = SomaUtils.stringXpathFor(nodeContent, ".")) != null) {
            Base64.base64ToBinaryFile(content, params.get("local"));
            result.remove("rawresponse");
            throwException = false;
        }
        if (throwException && this.errorsAreSignificant(params)) {
            throw new RuntimeException("failed to get the file " + params.get("remote") + ", rawresponse=" + result.get("rawresponse"));
        }
        return result;
    }

    public NamedParams doGetFilestore(NamedParams params) throws Exception {
        NamedParams result;
        block4: {
            params.insistOn(new String[]{"domain", "filestore"});
            String filestore = params.get("filestore");
            if (!filestore.endsWith(":")) {
                filestore = filestore + ":";
            }
            String body = "<soma:get-filestore location=\"" + filestore + "\"/>";
            String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
            result = params;
            try {
                result = this.conn.sendAndReceive(params, request);
                Node root = SomaUtils.getDOM(result.get("rawresponse"));
                Node nodeLocation = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:filestore/location");
                if (nodeLocation != null) {
                    result.set("location", SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nodeLocation)));
                }
            }
            catch (Exception e) {
                if (!this.errorsAreSignificant(params)) break block4;
                throw e;
            }
        }
        return result;
    }

    public NamedParams doGetLog(NamedParams params) throws Exception {
        NamedParams result;
        block2: {
            params.insistOn(new String[]{"domain"});
            String body = "<soma:get-log/>";
            String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
            result = params;
            try {
                result = this.conn.sendAndReceive(params, request);
                Node root = SomaUtils.getDOM(result.get("rawresponse"));
                Node nodeLog = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:log");
                result.set("log", SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nodeLog)));
            }
            catch (Exception e) {
                if (!this.errorsAreSignificant(params)) break block2;
                throw e;
            }
        }
        return result;
    }

    public NamedParams doGetObjectStatus(NamedParams params) throws Exception {
        params.insistOn("domain");
        NamedParams status = this.doGetStatus(params, "ObjectStatus");
        Node root = SomaUtils.getDOM(status.get("rawresponse"));
        Node nodeStatus = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:status");
        NamedParams result = new NamedParams();
        String[] in = params.toStringArray();
        boolean bClassSpecificationFound = false;
        for (int i = 0; i < in.length; ++i) {
            String classname;
            if (!in[i].startsWith("capture.") || (classname = in[i].substring("capture.".length())).length() <= 0) continue;
            bClassSpecificationFound = true;
            NodeList list = SomaUtils.nodelistXpathFor(nodeStatus, "ObjectStatus[Class='" + classname + "']");
            for (int k = 0; k < list.getLength(); ++k) {
                String objStat = SomaUtils.xmlNoHeader(SomaUtils.serializeXML(SomaUtils.nodeXpathFor(list.item(k), ".")));
                String objname = SomaUtils.stringXpathFor(list.item(k), "Name");
                if (!objname.matches(in[i + 1])) continue;
                result.set(classname + "." + objname, objStat);
            }
        }
        if (!bClassSpecificationFound) {
            NodeList list = SomaUtils.nodelistXpathFor(nodeStatus, "ObjectStatus");
            for (int k = 0; k < list.getLength(); ++k) {
                String objStat = SomaUtils.xmlNoHeader(SomaUtils.serializeXML(SomaUtils.nodeXpathFor(list.item(k), ".")));
                String objClass = SomaUtils.stringXpathFor(list.item(k), "Class");
                result.set(objClass + "." + SomaUtils.stringXpathFor(list.item(k), "Name"), objStat);
            }
        }
        return result;
    }

    private NamedParams doGetStatus(NamedParams params, String objectClass) throws Exception {
        NamedParams result;
        block2: {
            params.insistOn("domain");
            String body = "<soma:get-status class=\"" + objectClass + "\"/>";
            String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
            result = params;
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                if (!this.errorsAreSignificant(params)) break block2;
                throw e;
            }
        }
        return result;
    }

    public NamedParams doGetStatuses(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "statuses"});
        String[] names = params.get("statuses").split("\\s+");
        StringBuffer statuses = new StringBuffer();
        statuses.append("<status>");
        for (int i = 0; i < names.length; ++i) {
            NamedParams oneresult = this.doGetStatus(params, names[i]);
            Node root = SomaUtils.getDOM(oneresult.get("rawresponse"));
            NodeList nodelistStatus = SomaUtils.nodelistXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:status/" + names[i]);
            if (nodelistStatus == null) continue;
            for (int k = 0; k < nodelistStatus.getLength(); ++k) {
                statuses.append(SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nodelistStatus.item(k))));
            }
        }
        statuses.append("</status>");
        NamedParams result = new NamedParams(params);
        result.set("status", statuses.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamedParams doImportConfig(NamedParams params) throws Exception {
        NamedParams result;
        block16: {
            String body;
            block14: {
                params.insistOn(new String[]{"domain", "local"});
                body = "<soma:do-import";
                body = params.get("source-type") != null ? body + " source-type=\"" + params.get("source-type") + "\"" : (params.get("local").toLowerCase().endsWith(".zip") ? body + " source-type=\"ZIP\"" : body + " source-type=\"XML\"");
                body = body + " dry-run=\"false\"";
                body = params.get("overwrite-files") != null ? body + " overwrite-files=\"" + params.get("overwrite-files") + "\"" : body + " overwrite-files=\"true\"";
                body = params.get("overwrite-objects") != null ? body + " overwrite-objects=\"" + params.get("overwrite-objects") + "\"" : body + " overwrite-objects=\"true\"";
                body = params.get("rewrite-local-ip") != null ? body + " rewrite-local-ip=\"" + params.get("rewrite-local-ip") + "\"" : body + " rewrite-local-ip=\"true\"";
                body = params.get("deployment-policy") != null ? body + " deployment-policy=\"" + params.get("deployment-policy") + "\"" : body + " deployment-policy=\"\"";
                body = body + ">";
                body = body + "<soma:input-file>" + Base64.base64FromBinaryFile(params.get("local")) + "</soma:input-file>";
                if (params.get("deployment-policy-file") != null) {
                    try {
                        String filename = params.get("deployment-policy-file");
                        File file = new File(filename);
                        if (file.length() <= 0L) break block14;
                        byte[] buffer = new byte[(int)file.length()];
                        BufferedInputStream input = new BufferedInputStream(new FileInputStream(filename));
                        try {
                            input.read(buffer);
                        }
                        finally {
                            input.close();
                        }
                        String rawcontent = Base64.bytesToString(buffer);
                        String content = null;
                        try {
                            Node doc = SomaUtils.getDOM(rawcontent);
                            Node wrapper = SomaUtils.nodeXpathFor(doc, "/*[local-name()='wrapper' and namespace-uri()='urn:datapower:configuration:manager']");
                            if (wrapper != null) {
                                NodeList nl = SomaUtils.nodelistXpathFor(wrapper, "*");
                                StringBuffer sb = new StringBuffer();
                                for (int i = 0; i < nl.getLength(); ++i) {
                                    sb.append(SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nl.item(i))));
                                }
                                content = sb.toString();
                            } else {
                                content = SomaUtils.xmlNoHeader(rawcontent);
                            }
                        }
                        catch (Exception e) {
                            content = SomaUtils.xmlNoHeader(rawcontent);
                        }
                        if (content != null) {
                            body = body + "<soma:deployment-policy>" + content + "</soma:deployment-policy>";
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            body = body + "</soma:do-import>";
            String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
            result = params;
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                if (!this.errorsAreSignificant(params)) break block16;
                throw e;
            }
        }
        return result;
    }

    public NamedParams doImportExecute(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name"});
        String body = "<ImportExecute><ImportPackageName>" + params.get("name") + "</ImportPackageName></ImportExecute>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NamedParams doIsUp(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "classname", "objname"});
        NamedParams result = this.doGetStatus(params, "ObjectStatus");
        Node root = SomaUtils.getDOM(result.get("rawresponse"));
        if (root == null) throw new RuntimeException("Failed to parse status information for " + params.get("classname") + "/" + params.get("objname") + ", rawresponse=" + result.get("rawresponse"));
        Node objectStatus = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:status/ObjectStatus[Class='" + params.get("classname") + "' and Name='" + params.get("objname") + "']");
        if (objectStatus == null) throw new RuntimeException("Failed to find the status of " + params.get("classname") + "/" + params.get("objname") + ", it does not exist.");
        String state = SomaUtils.stringXpathFor(objectStatus, "OpState");
        if (!state.trim().equals("up")) {
            throw new RuntimeException(params.get("classname") + "/" + params.get("objname") + " is either down or disabled.");
        }
        System.out.println(params.get("classname") + "/" + params.get("objname") + " is up in " + params.get("domain") + ".");
        return result;
    }

    public NamedParams doKeygen(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "cn"});
        StringBuffer body = new StringBuffer();
        body.append("<Keygen>");
        if (params.get("ldaporder") != null) {
            body.append("<LDAPOrder>" + params.get("ldaporder") + "</LDAPOrder>");
        }
        if (params.get("c") != null) {
            body.append("<C>" + params.get("c") + "</C>");
        }
        if (params.get("st") != null) {
            body.append("<ST>" + params.get("st") + "</ST>");
        }
        if (params.get("l") != null) {
            body.append("<L>" + params.get("l") + "</L>");
        }
        if (params.get("o") != null) {
            body.append("<O>" + params.get("o") + "</O>");
        }
        if (params.get("ou") != null) {
            body.append("<OU>" + params.get("ou") + "</OU>");
        }
        if (params.get("ou1") != null) {
            body.append("<OU1>" + params.get("ou1") + "</OU1>");
        }
        if (params.get("ou2") != null) {
            body.append("<OU2>" + params.get("ou2") + "</OU2>");
        }
        if (params.get("ou3") != null) {
            body.append("<OU3>" + params.get("ou3") + "</OU3>");
        }
        body.append("<CN>" + params.get("cn") + "</CN>");
        if (params.get("keylength") != null) {
            body.append("<KeyLength>" + params.get("keylength") + "</KeyLength>");
        }
        if (params.get("remote") != null) {
            body.append("<FileName>" + params.get("remote") + "</FileName>");
        }
        if (params.get("days") != null) {
            body.append("<Days>" + params.get("days") + "</Days>");
        }
        if (params.get("password") != null) {
            body.append("<Password>" + params.get("password") + "</Password>");
        }
        if (params.get("passwordalias") != null) {
            body.append("<PasswordAlias>" + params.get("passwordalias") + "</PasswordAlias>");
        }
        if (params.get("kwkexportable") != null) {
            body.append("<KwkExportable>" + params.get("kwkexportable") + "</KwkExportable>");
        }
        if (params.get("exportkey") != null) {
            body.append("<ExportKey>" + params.get("exportkey") + "</ExportKey>");
        }
        if (params.get("gensscert") != null) {
            body.append("<GenSSCert>" + params.get("gensscert") + "</GenSSCert>");
        }
        if (params.get("exportsscert") != null) {
            body.append("<ExportSSCert>" + params.get("exportsscert") + "</ExportSSCert>");
        }
        if (params.get("genobject") != null) {
            body.append("<GenObject>" + params.get("genobject") + "</GenObject>");
        }
        if (params.get("objectname") != null) {
            body.append("<ObjectName>" + params.get("objectname") + "</ObjectName>");
        }
        if (params.get("hsm") != null) {
            body.append("<HSM>" + params.get("hsm") + "</HSM>");
        }
        if (params.get("usingkey") != null) {
            body.append("<UsingKey>" + params.get("usingkey") + "</UsingKey>");
        }
        body.append("</Keygen>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doLocateDevice(NamedParams params) throws Exception {
        params.insistOn(new String[]{"state"});
        String body = "<LocateDevice><LocateLED>" + params.get("state") + "</LocateLED></LocateDevice>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doMemoryStatus(NamedParams params) throws Exception {
        String usage;
        params.set("domain", "default");
        NamedParams result = this.doGetStatus(params, "MemoryStatus");
        Node root = SomaUtils.getDOM(result.get("rawresponse"));
        Node nodeStatus = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:status/MemoryStatus");
        boolean throwException = true;
        if (nodeStatus != null && (usage = SomaUtils.stringXpathFor(nodeStatus, "Usage")).length() > 0) {
            result.set("Usage", usage);
            result.set("TotalMemory", SomaUtils.stringXpathFor(nodeStatus, "TotalMemory"));
            result.set("UsedMemory", SomaUtils.stringXpathFor(nodeStatus, "UsedMemory"));
            result.set("FreeMemory", SomaUtils.stringXpathFor(nodeStatus, "FreeMemory"));
            result.set("ReqMemory", SomaUtils.stringXpathFor(nodeStatus, "ReqMemory"));
            throwException = false;
        }
        if (throwException && this.errorsAreSignificant(params)) {
            throw new UnsupportedOperationException(result.get("rawresponse"));
        }
        return result;
    }

    public NamedParams doModifyConfig(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "config"});
        String body = "<soma:modify-config>" + SomaUtils.xmlNoHeader(params.get("config")) + "</soma:modify-config>";
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doMoveFile(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "source", "destination"});
        StringBuffer body = new StringBuffer();
        body.append("<MoveFile>");
        body.append("<sURL>" + params.get("source") + "</sURL>");
        body.append("<dURL>" + params.get("destination") + "</dURL>");
        if (params.get("overwrite") != null) {
            body.append("<Overwrite>" + params.get("overwrite") + "</Overwrite>");
        }
        body.append("</MoveFile>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doNoPasswordMap(NamedParams params) throws Exception {
        String body = "<NoPasswordMap/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doPasswordMap(NamedParams params) throws Exception {
        String body = "<PasswordMap/>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doPing(NamedParams params) throws Exception {
        params.insistOn(new String[]{"host"});
        StringBuffer body = new StringBuffer("<Ping>");
        body.append("<RemoteHost>" + params.get("host") + "</RemoteHost>");
        if (params.get("useipv") != null) {
            body.append("<useIPv>" + params.get("useipv") + "</useIPv>");
        }
        body.append("</Ping>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doQuiesceDevice(NamedParams params) throws Exception {
        params.insistOn(new String[]{"timeout"});
        StringBuffer body = new StringBuffer();
        body.append("<QuiesceDP>");
        body.append("<timeout>" + params.get("timeout") + "</timeout>");
        body.append("</QuiesceDP>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doQuiesceDomain(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "timeout"});
        StringBuffer body = new StringBuffer();
        body.append("<DomainQuiesce>");
        body.append("<name>" + params.get("domain") + "</name>");
        body.append("<timeout>" + params.get("timeout") + "</timeout>");
        body.append("</DomainQuiesce>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doQuiesceFSH(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "type", "objname", "fehtype", "fehname", "timeout"});
        StringBuffer body = new StringBuffer();
        body.append("<ServiceStatusQuiesce>");
        body.append("<type>" + params.get("type") + "</type>");
        body.append("<name>" + params.get("objname") + "</name>");
        body.append("<fehtype>" + params.get("fehtype") + "</fehtype>");
        body.append("<fehname>" + params.get("fehname") + "</fehname>");
        body.append("<timeout>" + params.get("timeout") + "</timeout>");
        body.append("</ServiceStatusQuiesce>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doQuiesceService(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "type", "objname", "timeout"});
        boolean wait = true;
        StringBuffer body = new StringBuffer();
        body.append("<ServiceQuiesce>");
        body.append("<type>" + params.get("type") + "</type>");
        body.append("<name>" + params.get("objname") + "</name>");
        body.append("<timeout>" + params.get("timeout") + "</timeout>");
        body.append("</ServiceQuiesce>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                wait = false;
            }
        }
        if (wait) {
            NamedParams waitOnQuiesce = new NamedParams(params);
            String serviceProp = params.get("type") + "." + params.get("objname");
            waitOnQuiesce.set("capture." + params.get("type"), params.get("objname"));
            while (wait) {
                NamedParams tmp = this.doGetObjectStatus(waitOnQuiesce);
                Node root = SomaUtils.getDOM(tmp.get(serviceProp));
                Node nodeResponse = SomaUtils.nodeXpathFor(root, "/ObjectStatus/ErrorCode[contains(., 'quiescence')]");
                if (nodeResponse != null) {
                    wait = false;
                    continue;
                }
                Thread.sleep(3000L);
            }
        }
        return result;
    }

    public NamedParams doRefreshDocument(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "xmlmanager", "doc"});
        String body = "<RefreshDocument><XMLManager>" + params.get("xmlmanager") + "</XMLManager><Document>" + params.get("doc") + "</Document></RefreshDocument>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doRefreshStylesheet(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "xmlmanager", "stylesheet"});
        String body = "<RefreshStylesheet><XMLManager>" + params.get("xmlmanager") + "</XMLManager><Stylesheet>" + params.get("stylesheet") + "</Stylesheet></RefreshStylesheet>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doRefreshTAMCerts(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "tamuid", "tampwd"});
        StringBuffer body = new StringBuffer();
        body.append("<RefreshTAMCerts>");
        body.append("<TAMObject>" + params.get("objname") + "</TAMObject>");
        body.append("<Administrator>" + params.get("tamuid") + "</Administrator>");
        body.append("<Password>" + params.get("tampwd") + "</Password>");
        body.append("</RefreshTAMCerts>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doRemoveCheckpoint(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name"});
        String body = "<RemoveCheckpoint><ChkName>" + params.get("name") + "</ChkName></RemoveCheckpoint>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doRemoveDirectory(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "remote"});
        String body = "<RemoveDir><Dir>" + params.get("remote") + "</Dir>" + "</RemoveDir>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doRemoveStylesheet(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "xmlmanager"});
        StringBuffer body = new StringBuffer();
        body.append("<RemoveStylesheet>");
        body.append("<XMLManager>" + params.get("xmlmanager") + "</XMLManager>");
        if (params.get("pattern") != null) {
            body.append("<MatchPattern>" + params.get("pattern") + "</MatchPattern>");
        }
        body.append("</RemoveStylesheet>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doResetDomain(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        String body = "<ResetThisDomain/>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doRestartDomain(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        String body = "<RestartThisDomain/>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doRestore(NamedParams params) throws Exception {
        NamedParams result;
        block17: {
            params.insistOn(new String[]{"domain", "local"});
            StringBuffer body = new StringBuffer();
            body.append("<soma:do-restore");
            if (params.get("format") != null) {
                body.append(" source-type=\"" + params.get("format") + "\"");
            } else {
                body.append(" source-type=\"ZIP\"");
            }
            if (params.get("dry-run") != null) {
                body.append(" dry-run=\"" + params.get("dry-run") + "\"");
            } else {
                body.append(" dry-run=\"false\"");
            }
            if (params.get("overwrite-files") != null) {
                body.append(" overwrite-files=\"" + params.get("overwrite-files") + "\"");
            } else {
                body.append(" overwrite-files=\"true\"");
            }
            if (params.get("overwrite-objects") != null) {
                body.append(" overwrite-objects=\"" + params.get("overwrite-objects") + "\"");
            } else {
                body.append(" overwrite-objects=\"true\"");
            }
            if (params.get("rewrite-local-ip") != null) {
                body.append(" rewrite-local-ip=\"" + params.get("rewrite-local-ip") + "\"");
            } else {
                body.append(" rewrite-local-ip=\"false\"");
            }
            if (params.get("deployment-policy-name") != null) {
                body.append(" deployment-policy=\"" + params.get("deployment-policy-name") + "\"");
            }
            body.append(">");
            body.append("<soma:input-file>" + Base64.base64FromBinaryFile(params.get("local")) + "</soma:input-file>");
            body.append("<soma:domain name=\"" + params.get("domain") + "\" import-domain=\"true\" reset-domain=\"true\"/>");
            if (params.get("domains") != null) {
                String[] names = params.get("domains").split("\\s+");
                for (int i = 0; i < names.length; ++i) {
                    if (names[i].equals(params.get("domain"))) continue;
                    body.append("<soma:domain name=\"" + names[i] + "\"/>");
                }
            }
            if (params.get("deployment-policy") != null) {
                body.append(params.get("deployment-policy"));
            }
            body.append("</soma:do-restore>");
            String request = SomaUtils.getGeneralEnvelope("default", body.toString());
            result = params;
            try {
                result = this.conn.sendAndReceive(params, request);
                Node root = SomaUtils.getDOM(result.get("rawresponse"));
                Node nodeResponse = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:import");
                if (nodeResponse == null && this.errorsAreSignificant(params)) {
                    throw new RuntimeException("Failed to restore on " + params.get("hostname"));
                }
            }
            catch (Exception e) {
                if (!this.errorsAreSignificant(params)) break block17;
                throw e;
            }
        }
        return result;
    }

    public NamedParams doRollbackCheckpoint(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name"});
        String body = "<RollbackCheckpoint><ChkName>" + params.get("name") + "</ChkName></RollbackCheckpoint>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSaveCheckpoint(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name"});
        String body = "<SaveCheckpoint><ChkName>" + params.get("name") + "</ChkName></SaveCheckpoint>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSaveConfig(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        String body = "<SaveConfig/>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSecureBackup(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<SecureBackup>");
        body.append("<cert>" + params.get("objname") + "</cert>");
        body.append("<destination>" + params.get("remote") + "</destination>");
        if (params.get("include-iscsi") != null) {
            body.append("<include-iscsi>" + params.get("include-iscsi") + "</include-iscsi>");
        } else {
            body.append("<include-iscsi>off</include-iscsi>");
        }
        if (params.get("include-raid") != null) {
            body.append("<include-raid>" + params.get("include-raid") + "</include-raid>");
        } else {
            body.append("<include-raid>off</include-raid>");
        }
        body.append("</SecureBackup>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSecureRestore(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "objname", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<SecureRestore>");
        body.append("<cred>" + params.get("objname") + "</cred>");
        body.append("<source>" + params.get("remote") + "</source>");
        if (params.get("validate") != null) {
            body.append("<validate>" + params.get("validate") + "</validate>");
        } else {
            body.append("<validate>off</validate>");
        }
        if (params.get("type") != null) {
            body.append("<BackupMachineType>" + params.get("type") + "</BackupMachineType>");
        }
        body.append("</SecureRestore>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSelectConfig(NamedParams params) throws Exception {
        params.insistOn(new String[]{"remote"});
        String body = "<SelectConfig><File>" + params.get("remote") + "</File></SelectConfig>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSendErrorReport(NamedParams params) throws Exception {
        params.insistOn(new String[]{"host", "location", "address"});
        String body = "<SendErrorReport><SmtpServer>" + params.get("host") + "</SmtpServer>" + "<LocationIdentifier>" + params.get("location") + "</LocationIdentifier>" + "<EmailAddress>" + params.get("address") + "</EmailAddress>" + "</SendErrorReport>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSendFile(NamedParams params) throws Exception {
        params.insistOn(new String[]{"host", "remote", "address"});
        String body = "<SendFile><LocationIdentifier>" + params.get("remote") + "</LocationIdentifier>" + "<SmtpServer>" + params.get("host") + "</SmtpServer>" + "<EmailAddress>" + params.get("address") + "</EmailAddress>" + "</SendFile>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSendLogEvent(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "logcategory", "loglevel", "msg"});
        StringBuffer body = new StringBuffer();
        body.append("<SendLogEvent>");
        body.append("<LogType>" + params.get("logcategory") + "</LogType>");
        body.append("<GenLogLevel>" + params.get("loglevel") + "</GenLogLevel>");
        body.append("<LogEvent>" + params.get("msg") + "</LogEvent>");
        if (params.get("eventcode") != null) {
            body.append("<EventCode>" + params.get("eventcode") + "</EventCode>");
        }
        body.append("</SendLogEvent>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSetConfig(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "config"});
        String body = "<soma:set-config>" + SomaUtils.xmlNoHeader(params.get("config")) + "</soma:set-config>";
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSetFile(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "local", "remote"});
        String base64FileContent = Base64.base64FromBinaryFile(params.get("local"));
        return this.doSetFileImpl(params, base64FileContent);
    }

    public NamedParams doSetLogLevel(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "loglevel"});
        StringBuffer body = new StringBuffer();
        body.append("<SetLogLevel>");
        body.append("<LogLevel>" + params.get("loglevel") + "</LogLevel>");
        if (params.get("domain").equals("default")) {
            if (params.get("internallog") != null) {
                body.append("<InternalLog>" + params.get("internallog") + "</InternalLog>");
            }
            if (params.get("rbmlog") != null) {
                body.append("<RBMLog>" + params.get("rbmlog") + "</RBMLog>");
            }
            if (params.get("globalfilter") != null) {
                body.append("<GlobalIPLogFilter>" + params.get("globalfilter") + "</GlobalIPLogFilter>");
            }
        }
        body.append("</SetLogLevel>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSetRBMLogLevel(NamedParams params) throws Exception {
        params.insistOn(new String[]{"rbmlog"});
        StringBuffer body = new StringBuffer();
        body.append("<SetRBMDebugLog>");
        body.append("<RBMLog>" + params.get("rbmlog") + "</RBMLog>");
        body.append("</SetRBMDebugLog>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSetSystemVar(NamedParams params) throws Exception {
        params.insistOn(new String[]{"name", "value"});
        StringBuffer body = new StringBuffer();
        body.append("<SetSystemVar>");
        body.append("<Var>" + params.get("name") + "</Var>");
        body.append("<Value>" + params.get("value") + "</Value>");
        body.append("</SetSystemVar>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doSetTimeAndDate(NamedParams params) throws Exception {
        StringBuffer body = new StringBuffer();
        body.append("<SetTimeAndDate>");
        if (params.get("date") != null) {
            body.append("<Date>" + params.get("date") + "</Date>");
        }
        if (params.get("time") != null) {
            body.append("<Time>" + params.get("time") + "</Time>");
        }
        body.append("</SetTimeAndDate>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doShutdown(NamedParams params) throws Exception {
        params.insistOn(new String[]{"mode"});
        StringBuffer body = new StringBuffer();
        body.append("<Shutdown>");
        body.append("<Mode>" + params.get("mode") + "</Mode>");
        if (params.get("delay") != null) {
            body.append("<Delay>" + params.get("delay") + "</Delay>");
        }
        body.append("</Shutdown>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doTCPConnectionTest(NamedParams params) throws Exception {
        params.insistOn(new String[]{"host", "port"});
        StringBuffer body = new StringBuffer("<TCPConnectionTest>");
        body.append("<RemoteHost>" + params.get("host") + "</RemoteHost>");
        body.append("<RemotePort>" + params.get("port") + "</RemotePort>");
        if (params.get("useipv") != null) {
            body.append("<useIPv>" + params.get("useipv") + "</useIPv>");
        }
        body.append("</TCPConnectionTest>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doTestPasswordMap(NamedParams params) throws Exception {
        params.insistOn(new String[]{"type", "aliasname", "remote"});
        StringBuffer body = new StringBuffer();
        body.append("<TestPasswordMap>");
        body.append("<AliasName>" + params.get("aliasname") + "</AliasName>");
        body.append("<Type>" + params.get("type") + "</Type>");
        body.append("<FileURL>" + params.get("remote") + "</FileURL>");
        body.append("<TestPasswordMap>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doTestURLMap(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name", "url"});
        String body = "<TestURLMap><URLMap>" + params.get("name") + "</URLMap>" + "<URL>" + params.get("url") + "</URL>" + "</TestURLMap>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doTestURLRefresh(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name", "url"});
        String body = "<TestURLRefresh><URLRefreshPolicy>" + params.get("name") + "</URLRefreshPolicy>" + "<URL>" + params.get("url") + "</URL>" + "</TestURLRefresh>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doTestURLRewrite(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name", "url"});
        String body = "<TestURLRewrite><URLRewritePolicy>" + params.get("name") + "</URLRewritePolicy>" + "<URL>" + params.get("url") + "</URL>" + "</TestURLRewrite>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doTestValidateSchema(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "xml", "schema"});
        String body = "<TestValidateSchema><XMLFile>" + params.get("xml") + "</XMLFile>" + "<SchemaFile>" + params.get("schema") + "</SchemaFile>" + "</TestValidateSchema>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUndoConfig(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "classname", "objname"});
        String body = "<UndoConfig><Class>" + params.get("classname") + "</Class>" + "<Name>" + params.get("objname") + "</Name>" + "</UndoConfig>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUniversalPacketCaptureDebug(NamedParams params) throws Exception {
        params.insistOn(new String[]{"type", "maxsize", "maxpacketsize"});
        StringBuffer body = new StringBuffer();
        body.append("<UniversalPacketCaptureDebug>");
        body.append("<InterfaceType>" + params.get("type") + "</InterfaceType>");
        if (params.get("ethernet-int") != null) {
            body.append("<EthernetInterface>" + params.get("ethernet-int") + "</EthernetInterface>");
        }
        if (params.get("vlan-int") != null) {
            body.append("<VLANInterface>" + params.get("vlan-int") + "</VLANInterface>");
        }
        if (params.get("mode") != null && params.get("maxtime") != null) {
            body.append("<CaptureMode>" + params.get("mode") + "</CaptureMode>");
            body.append("<MaxTime>" + params.get("maxtime") + "</MaxTime>");
        } else {
            if (params.get("mode").equals("timed") && params.get("maxtime") == null) {
                throw new RuntimeException("universal packet capture - you specified mode=\"timed\" but didn't specify maxtime=\"nnn\".");
            }
            if (params.get("mode") != null) {
                body.append("<CaptureMode>" + params.get("mode") + "</CaptureMode>");
            } else {
                body.append("<CaptureMode>timed</CaptureMode>");
                body.append("<MaxTime>10</MaxTime>");
            }
        }
        body.append("<MaxSize>" + params.get("maxsize") + "</MaxSize>");
        body.append("<MaxPacketSize>" + params.get("maxpacketsize") + "</MaxPacketSize>");
        if (params.get("filter") != null) {
            body.append("<Filter>" + params.get("filter") + "</Filter>");
        }
        body.append("</UniversalPacketCaptureDebug>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUniversalStopPacketCapture(NamedParams params) throws Exception {
        params.insistOn(new String[]{"type"});
        StringBuffer body = new StringBuffer();
        body.append("<UniversalStopPacketCapture>");
        body.append("<InterfaceType>" + params.get("type") + "</InterfaceType>");
        if (params.get("ethernet-int") != null) {
            body.append("<EthernetInterface>" + params.get("ethernet-int") + "</EthernetInterface>");
        }
        if (params.get("vlan-int") != null) {
            body.append("<VLANInterface>" + params.get("vlan-int") + "</VLANInterface>");
        }
        body.append("</UniversalStopPacketCapture>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUnquiesceDevice(NamedParams params) throws Exception {
        StringBuffer body = new StringBuffer();
        body.append("<UnquiesceDP/>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUnquiesceDomain(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        StringBuffer body = new StringBuffer();
        body.append("<DomainUnquiesce>");
        body.append("<name>" + params.get("domain") + "</name>");
        body.append("</DomainUnquiesce>");
        String request = SomaUtils.getDoActionEnvelope("default", body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUnquiesceFSH(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "type", "objname", "fehtype", "fehname"});
        StringBuffer body = new StringBuffer();
        body.append("<ServiceStatusUnquiesce>");
        body.append("<type>" + params.get("type") + "</type>");
        body.append("<name>" + params.get("objname") + "</name>");
        body.append("<fehtype>" + params.get("fehtype") + "</fehtype>");
        body.append("<fehname>" + params.get("fehname") + "</fehname>");
        body.append("</ServiceStatusUnquiesce>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUnquiesceService(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "type", "objname"});
        StringBuffer body = new StringBuffer();
        body.append("<ServiceUnquiesce>");
        body.append("<type>" + params.get("type") + "</type>");
        body.append("<name>" + params.get("objname") + "</name>");
        body.append("</ServiceUnquiesce>");
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body.toString());
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUpload(NamedParams params) throws Exception {
        boolean recurse;
        LocalFiles locals;
        Vector<LocalFiles.Entry> biglist;
        String pattern;
        params.insistOn(new String[]{"domain", "remote"});
        String basedir = params.get("local");
        if (basedir == null || basedir.length() == 0) {
            basedir = ".";
        }
        if ((pattern = params.get("pattern")) == null || pattern.length() == 0) {
            pattern = ".*";
        }
        if ((biglist = (locals = new LocalFiles()).fill(basedir, pattern, recurse = this.isTrue(params, "recurse"))).size() > 0) {
            LocalFiles.Entry entry;
            int i;
            String rmtdir;
            if (!basedir.endsWith(File.separator)) {
                basedir = basedir + File.separator;
            }
            if (!(rmtdir = params.get("remote")).endsWith("/")) {
                rmtdir = rmtdir + "/";
            }
            NamedParams p = new NamedParams(params);
            String pat = "[a-z]+:/*[^/]+.*";
            if (Pattern.matches(pat, rmtdir)) {
                p.set("remote", rmtdir);
                System.out.println("Ensuring exists: " + p.get("remote"));
                this.doCreateDirectory(p);
            }
            for (i = biglist.size() - 1; i >= 0; --i) {
                entry = biglist.get(i);
                if (!entry.isDirectory()) continue;
                p.set("remote", (rmtdir + entry.getName()).replace('\\', '/'));
                System.out.println("Ensuring exists: " + p.get("remote"));
                this.doCreateDirectory(p);
            }
            p = new NamedParams(params);
            for (i = 0; i < biglist.size(); ++i) {
                entry = biglist.get(i);
                if (entry.isDirectory()) continue;
                p.set("local", basedir + entry.getName());
                p.set("remote", (rmtdir + entry.getName()).replace('\\', '/'));
                System.out.println("Uploading " + p.get("local") + " to " + p.get("remote"));
                this.doSetFile(p);
            }
        } else {
            System.out.println("No files to upload.");
        }
        return params;
    }

    public NamedParams doUserForcePasswordChange(NamedParams params) throws Exception {
        params.insistOn(new String[]{"dpuid"});
        String body = "<UserForcePasswordChange><User>" + params.get("dpuid") + "</User>" + "</UserForcePasswordChange>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUserResetFailedLogin(NamedParams params) throws Exception {
        params.insistOn(new String[]{"dpuid"});
        String body = "<UserResetFailedLogin><User>" + params.get("dpuid") + "</User>" + "</UserResetFailedLogin>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doUserResetPassword(NamedParams params) throws Exception {
        params.insistOn(new String[]{"dpuid", "dppwd"});
        String body = "<UserResetPassword><User>" + params.get("dpuid") + "</User>" + "<Password>" + params.get("dppwd") + "</Password>" + "</UserResetPassword>";
        String request = SomaUtils.getDoActionEnvelope("default", body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doValCredAddCertsFromDir(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain"});
        String body = "<ValCredAddCertsFromDir/>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public NamedParams doWSRRSynchronize(NamedParams params) throws Exception {
        params.insistOn(new String[]{"domain", "name"});
        String body = "<WsrrSynchronize><WSRRSubscription>" + params.get("name") + "</WSRRSubscription>" + "</WsrrSynchronize>";
        String request = SomaUtils.getDoActionEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private NamedParams doSetFileImpl(NamedParams params, String base64FileContent) throws Exception {
        params.insistOn(new String[]{"domain", "remote"});
        String body = "<soma:set-file name=\"" + params.get("remote") + "\">" + base64FileContent + "</soma:set-file>";
        String request = SomaUtils.getGeneralEnvelope(params.get("domain"), body);
        NamedParams result = params;
        if (this.errorsAreSignificant(params)) {
            result = this.conn.sendAndReceive(params, request);
            this.insistSomaResultIsOkay(result);
        } else {
            try {
                result = this.conn.sendAndReceive(params, request);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean errorsAreSignificant(NamedParams params) {
        boolean important = true;
        if (this.isTrue(params, "ignore-errors")) {
            important = false;
        }
        return important;
    }

    private void insistSomaResultIsOkay(NamedParams result) throws Exception {
        String okay;
        boolean throwException = true;
        Node root = SomaUtils.getDOM(result.get("rawresponse"));
        Node nodeResponse = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response");
        if (nodeResponse != null && (okay = SomaUtils.stringXpathFor(nodeResponse, "soma:result").trim()).equals("OK")) {
            throwException = false;
        }
        if (throwException) {
            throw new UnsupportedOperationException("Operation soma=" + result.get("soma") + " failed. rawresponse=" + result.get("rawresponse"));
        }
    }

    private boolean isTrue(NamedParams params, String paramName) {
        boolean bRet = false;
        String param = params.get(paramName);
        if (param != null && (param.equals("yes") || param.equals("YES") || param.equals("on") || param.equals("ON") || param.equals("true") || param.equals("TRUE") || param.equals("1"))) {
            bRet = true;
        }
        return bRet;
    }

    private class LocalFiles {
        private String basedir = "";
        private Pattern pattern;
        private boolean recurse = false;
        private Vector<Entry> biglist = new Vector();

        private LocalFiles() {
        }

        public Vector<Entry> fill(String basedir, String pattern, boolean recurse) throws Exception {
            this.biglist.clear();
            this.recurse = recurse;
            this.pattern = Pattern.compile(pattern);
            this.basedir = new File(basedir).getAbsolutePath();
            this.fillImpl(this.basedir, 0, "gathering : ");
            return this.biglist;
        }

        private boolean fillImpl(String dir, int depth, String padding) throws Exception {
            boolean bContainsFiles = false;
            File startHere = new File(dir);
            File[] entries = startHere.listFiles();
            if (entries != null) {
                for (int i = 0; i < entries.length; ++i) {
                    File entry = entries[i];
                    if (entry.getName().charAt(0) == '.') continue;
                    String name = entry.getPath();
                    name = name.substring(this.basedir.length() + File.pathSeparator.length());
                    if (this.pattern.matcher(entry.getName()).matches()) {
                        this.biglist.add(new Entry(name, entry.isDirectory()));
                        bContainsFiles = true;
                    }
                    if (!this.recurse || !entry.isDirectory() || !this.fillImpl(entry.getAbsolutePath(), depth + 1, padding + "  ")) continue;
                    bContainsFiles = true;
                    this.biglist.add(new Entry(name, entry.isDirectory()));
                }
            }
            return bContainsFiles;
        }

        public class Entry {
            private boolean isDir;
            private String name;

            public Entry(String name, boolean isDirectory) {
                this.isDir = isDirectory;
                this.name = name;
            }

            public boolean isDirectory() {
                return this.isDir;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

