/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.Base64;
import com.ibm.dcm.SSLConnection;
import com.ibm.dcm.SomaUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.resources.PropertyResource;

public class taskDpupload
extends MatchingTask {
    private Vector<Arg> args = new Vector();
    private Vector<PropertySet> propertysets = new Vector();
    private Vector<String> uploadedFiles = new Vector();
    private String successProperty = null;
    private String uploadedFilesProperty = null;
    private boolean dumpInput = false;
    private boolean dumpOutput = false;
    private String capturesoma = null;
    private static SSLConnection singletonConnection = null;

    public static SSLConnection getConnection() throws Exception {
        if (singletonConnection == null) {
            singletonConnection = new SSLConnection();
        }
        return singletonConnection;
    }

    public void setDir(File directory) {
        this.fileset.setDir(directory);
    }

    public void setFile(File file) {
        this.fileset.setFile(file);
    }

    public void setDomain(String domain) {
        this.args.add(new Arg("domain", domain));
    }

    public void setHost(String host) {
        this.args.add(new Arg("host", host));
    }

    public void setPort(String port) {
        this.args.add(new Arg("port", port));
    }

    public void setPwd(String pwd) {
        this.args.add(new Arg("pwd", pwd));
    }

    public void setTarget(String target) {
        this.args.add(new Arg("target", target));
    }

    public void setUid(String uid) {
        this.args.add(new Arg("uid", uid));
    }

    public void setUrl(String url) {
        this.args.add(new Arg("url", url));
    }

    public void setSuccessprop(String propname) {
        this.successProperty = propname;
    }

    public void setUploadedfilesprop(String propname) {
        this.uploadedFilesProperty = propname;
    }

    public void setDumpinput(boolean flag) {
        this.dumpInput = flag;
    }

    public void setDumpoutput(boolean flag) {
        this.dumpOutput = flag;
    }

    public void setCapturesoma(String filename) {
        this.capturesoma = filename;
    }

    public void execute() {
        Project proj = this.getProject();
        try {
            this.upload();
            if (this.successProperty != null) {
                proj.setProperty(this.successProperty, "true");
            }
            if (this.uploadedFilesProperty != null) {
                proj.setProperty(this.uploadedFilesProperty, this.fileListInXML(this.uploadedFiles));
            }
        }
        catch (Exception e) {
            if (this.successProperty != null) {
                proj.setProperty(this.successProperty, "false");
            }
            throw new BuildException((Throwable)e);
        }
    }

    public void addConfiguredPropertyset(PropertySet ps) {
        this.propertysets.add(ps);
        for (PropertyResource res : ps) {
            this.args.add(new Arg(res.getName(), res.getValue()));
        }
    }

    public Arg createDomain() {
        Arg arg = new Arg("domain");
        this.args.add(arg);
        return arg;
    }

    public Arg createHost() {
        Arg arg = new Arg("host");
        this.args.add(arg);
        return arg;
    }

    public Arg createPort() {
        Arg arg = new Arg("port");
        this.args.add(arg);
        return arg;
    }

    public Arg createPwd() {
        Arg arg = new Arg("pwd");
        this.args.add(arg);
        return arg;
    }

    public Arg createTarget() {
        Arg arg = new Arg("target");
        this.args.add(arg);
        return arg;
    }

    public Arg createUid() {
        Arg arg = new Arg("uid");
        this.args.add(arg);
        return arg;
    }

    public Arg createUrl() {
        Arg arg = new Arg("url");
        this.args.add(arg);
        return arg;
    }

    private String findArg(String name) {
        return this.findArg(name, "");
    }

    private String findArg(String name, String defaultValue) {
        String value = defaultValue;
        for (int i = 0; i < this.args.size(); ++i) {
            Arg arg = this.args.get(i);
            if (!arg.getName().equals(name)) continue;
            value = arg.getValue();
            break;
        }
        return value;
    }

    public void upload() throws Exception {
        HashSet<String> createdDirs = new HashSet<String>();
        DirectoryScanner dirScanner = this.getImplicitFileSet().getDirectoryScanner();
        String remoteRoot = this.findArg("target");
        if (remoteRoot.length() > 1 && remoteRoot.charAt(remoteRoot.length() - 1) != '/') {
            remoteRoot = remoteRoot + "/";
        }
        this.createDirectory(remoteRoot, createdDirs, true);
        String[] dirs = dirScanner.getIncludedDirectories();
        for (int i = 0; i < dirs.length; ++i) {
            String remote = remoteRoot + dirs[i];
            this.createDirectory(remote, createdDirs, true);
        }
        String[] files = dirScanner.getIncludedFiles();
        String path = dirScanner.getBasedir().getAbsolutePath();
        for (int i = 0; i < files.length; ++i) {
            String remote = remoteRoot + files[i];
            String local = path + File.separator + files[i];
            System.out.println("uploading file \"" + local + "\" to \"" + remote + "\" in domain " + this.findArg("domain"));
            String msg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><soma:request domain=\"" + this.findArg("domain") + "\" xmlns:soma=\"http://www.datapower.com/schemas/management\"><soma:set-file name=\"" + remote + "\">" + Base64.base64FromBinaryFile(local) + "</soma:set-file></soma:request></env:Body></env:Envelope>";
            String url = this.findArg("url");
            if (this.findArg("host").length() > 0) {
                url = "https://" + this.findArg("host") + ":" + this.findArg("port", "5550") + "/service/mgmt/current";
            }
            String result = taskDpupload.getConnection().sendAndReceive(url, this.findArg("uid"), this.findArg("pwd"), msg, this.dumpInput, this.dumpOutput, this.capturesoma);
            SomaUtils.ensureOK(result, "Failed uploading file " + remote);
            this.uploadedFiles.add(remote);
            this.uploadedFiles.add(files[i]);
        }
    }

    private void createDirectory(String remote, HashSet<String> createdDirectories, boolean isDirectoryName) throws Exception {
        int i = remote.indexOf(":///");
        if (i < 3) {
            throw new RuntimeException("The parameter \"remote\"=\"" + remote + "\" doesn't begin with a filestore (e.g. local:///).");
        }
        String base = remote.substring(0, i + ":///".length());
        String relativeDirs = remote.substring(i + ".///".length());
        String[] dirnames = relativeDirs.split("[/\\\\]");
        if (!isDirectoryName) {
            String[] names = new String[dirnames.length - 1];
            for (int n = 0; n < names.length; ++n) {
                names[n] = dirnames[n];
            }
            dirnames = names;
        }
        for (int k = 0; k < dirnames.length; ++k) {
            String dirname = new String(base);
            for (int n = 0; n < k; ++n) {
                dirname = dirname + dirnames[n] + "/";
            }
            if (createdDirectories.contains(dirname = dirname + dirnames[k])) continue;
            if (!dirname.endsWith(":///")) {
                String msg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><soma:request domain=\"" + this.findArg("domain") + "\" xmlns:soma=\"http://www.datapower.com/schemas/management\"><soma:do-action><CreateDir><Dir>" + dirname + "</Dir></CreateDir></soma:do-action></soma:request></env:Body></env:Envelope>";
                String url = this.findArg("url");
                if (this.findArg("host").length() > 0) {
                    url = "https://" + this.findArg("host") + ":" + this.findArg("port", "5550") + "/service/mgmt/current";
                }
                taskDpupload.getConnection().sendAndReceive(url, this.findArg("uid"), this.findArg("pwd"), msg, this.dumpInput, this.dumpOutput, this.capturesoma);
            }
            createdDirectories.add(dirname);
        }
    }

    private String fileListInXML(Vector<String> list) {
        StringBuffer sb = new StringBuffer();
        if (list.size() > 0) {
            sb.append("<files>");
            for (int i = 0; i < list.size(); i += 2) {
                String fullname = list.get(i);
                String filename = list.get(i + 1);
                sb.append("<file filenameonly=\"" + filename + "\">" + fullname + "</file>");
            }
            sb.append("</files>");
        } else {
            sb.append("<files/>");
        }
        return sb.toString();
    }

    public class Arg {
        String name;
        String value;

        public Arg(String name) {
            this.name = name;
        }

        public Arg(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void addText(String text) {
            this.value = text;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

