/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.MyNamespaces;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class SomaUtils {
    private static XPathFactory xpathFactory = XPathFactory.newInstance();
    private static MyNamespaces myNamespaces = new MyNamespaces();

    public static String getDoActionEnvelope(String domain, String actionBody) {
        String env = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><soma:request domain=\"" + domain + "\" xmlns:soma=\"http://www.datapower.com/schemas/management\">" + "<soma:do-action>" + actionBody + "</soma:do-action>" + "</soma:request>" + "</env:Body>" + "</env:Envelope>";
        return env;
    }

    public static String getGeneralEnvelope(String domain, String requestBody) {
        String env = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><soma:request domain=\"" + domain + "\" xmlns:soma=\"http://www.datapower.com/schemas/management\">" + requestBody + "</soma:request>" + "</env:Body>" + "</env:Envelope>";
        return env;
    }

    public static Node getDOM(String xml) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        return doc.getDocumentElement();
    }

    public static Node nodeXpathFor(Node root, String xpathDesired) throws Exception {
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(myNamespaces);
        Node nodeRet = (Node)xpath.evaluate(xpathDesired, root, XPathConstants.NODE);
        return nodeRet;
    }

    public static NodeList nodelistXpathFor(Node root, String xpathDesired) throws Exception {
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(myNamespaces);
        NodeList listRet = (NodeList)xpath.evaluate(xpathDesired, root, XPathConstants.NODESET);
        return listRet;
    }

    public static String stringXpathFor(Node root, String xpathDesired) throws Exception {
        XPath xpath = xpathFactory.newXPath();
        xpath.setNamespaceContext(myNamespaces);
        String strRet = (String)xpath.evaluate(xpathDesired, root, XPathConstants.STRING);
        return strRet;
    }

    public static String xmlNoHeader(String xml) {
        if (xml.startsWith("<?")) {
            StringBuffer buf = new StringBuffer(xml);
            while (buf.substring(0, 2).equals("<?")) {
                int end = buf.indexOf("?>");
                buf.delete(0, end + 2);
                while (buf.charAt(0) == '\n' || buf.charAt(0) == '\r') {
                    buf.deleteCharAt(0);
                }
            }
            return buf.toString();
        }
        return xml;
    }

    public static String serializeXML(Node root) {
        if (root == null) {
            return "<null/>";
        }
        if (root.getFeature("Core", "3.0") == null) {
            throw new UnsupportedOperationException("JVM doesn't support DOM Core 3.0");
        }
        if (root.getFeature("LS", "3.0") == null) {
            throw new UnsupportedOperationException("JVM doesn't support DOM LS 3.0");
        }
        DOMImplementationLS ls = (DOMImplementationLS)root.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer lss = ls.createLSSerializer();
        String result = lss.writeToString(root);
        return result;
    }

    public static void ensureOK(String dpresponse, String explanation) throws Exception {
        String okay;
        Node dom = SomaUtils.getDOM(dpresponse);
        Node nodeResponse = SomaUtils.nodeXpathFor(dom, "/env:Envelope/env:Body/soma:response");
        if (nodeResponse != null && !(okay = SomaUtils.stringXpathFor(nodeResponse, "soma:result").trim()).equals("OK")) {
            throw new RuntimeException(explanation + " : " + SomaUtils.xmlNoHeader(SomaUtils.serializeXML(SomaUtils.nodeXpathFor(dom, "/env:Envelope/env:Body/soma:response/soma:result"))));
        }
    }
}

