/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.Base64;
import com.ibm.dcm.SSLConnection;
import com.ibm.dcm.SomaUtils;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.w3c.dom.Node;

public class taskDpdownload
extends MatchingTask {
    private Vector<Arg> args = new Vector();
    private String successProperty = null;
    private boolean dumpInput = false;
    private boolean dumpOutput = false;
    private String capturesoma = null;
    private static SSLConnection singletonConnection = null;

    public static SSLConnection getConnection() throws Exception {
        if (singletonConnection == null) {
            singletonConnection = new SSLConnection();
        }
        return singletonConnection;
    }

    public void setDir(String dir) {
        this.args.add(new Arg("dir", dir));
    }

    public void setDpdir(String dpdir) {
        this.args.add(new Arg("dpdir", dpdir));
    }

    public void setDomain(String domain) {
        this.args.add(new Arg("domain", domain));
    }

    public void setFilename(String filename) {
        this.args.add(new Arg("filename", filename));
    }

    public void setHostname(String hostname) {
        this.args.add(new Arg("hostname", hostname));
    }

    public void setIgnoreerror(String tf) {
        this.args.add(new Arg("ignoreerror", tf));
    }

    public void setPort(String port) {
        this.args.add(new Arg("port", port));
    }

    public void setPwd(String pwd) {
        this.args.add(new Arg("pwd", pwd));
    }

    public void setUid(String uid) {
        this.args.add(new Arg("uid", uid));
    }

    public void setSuccessprop(String propname) {
        this.successProperty = propname;
    }

    public void setDumpinput(boolean flag) {
        this.dumpInput = flag;
    }

    public void setDumpoutput(boolean flag) {
        this.dumpOutput = flag;
    }

    public void setCapturesoma(String filename) {
        this.capturesoma = filename;
    }

    public void execute() {
        Project proj = this.getProject();
        try {
            this.download();
            if (this.successProperty != null) {
                proj.setProperty(this.successProperty, "true");
            }
        }
        catch (Exception e) {
            if (this.successProperty != null) {
                proj.setProperty(this.successProperty, "false");
            }
            throw new BuildException((Throwable)e);
        }
    }

    private String findArg(String name) {
        String value = "";
        for (int i = 0; i < this.args.size(); ++i) {
            Arg arg = this.args.get(i);
            if (!arg.getName().equals(name)) continue;
            value = arg.getValue();
            break;
        }
        return value;
    }

    public void download() throws Exception {
        String localDir;
        String remoteDir = this.findArg("dpdir");
        if (remoteDir.length() > 1 && remoteDir.charAt(remoteDir.length() - 1) != '/') {
            remoteDir = remoteDir + "/";
        }
        if ((localDir = this.findArg("dir")).length() > 1 && localDir.charAt(localDir.length() - 1) != '/') {
            localDir = localDir + "/";
        }
        String remoteName = remoteDir + this.findArg("filename");
        String localName = localDir + this.findArg("filename");
        String msg = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><env:Envelope xmlns:env=\"http://schemas.xmlsoap.org/soap/envelope/\"><env:Body><soma:request domain=\"" + this.findArg("domain") + "\" xmlns:soma=\"http://www.datapower.com/schemas/management\"><soma:get-file name=\"" + remoteName + "\"/></soma:request></env:Body></env:Envelope>";
        String port = this.findArg("port");
        if (port == null || port.length() == 0) {
            port = "5550";
        }
        String url = "https://" + this.findArg("hostname") + ":" + port + "/service/mgmt/current";
        String result = taskDpdownload.getConnection().sendAndReceive(url, this.findArg("uid"), this.findArg("pwd"), msg, this.dumpInput, this.dumpOutput, this.capturesoma);
        Node root = SomaUtils.getDOM(result);
        Node nodeContent = SomaUtils.nodeXpathFor(root, "/env:Envelope/env:Body/soma:response/soma:file");
        if (nodeContent != null) {
            String content = SomaUtils.stringXpathFor(nodeContent, ".");
            if (content != null) {
                Base64.base64ToBinaryFile(content, localName);
                System.out.println("Downloaded " + remoteName + " to " + localName);
            } else {
                System.out.println("FAILED to download " + remoteName + " to " + localName);
                if (this.findArg("ignoreerror") == null || !this.findArg("ignoreerror").equals("true")) {
                    System.out.println("Response from DataPower: " + result);
                    throw new RuntimeException("FAILED to download " + remoteName + " to " + localName);
                }
            }
        } else {
            System.out.println("FAILED to download " + remoteName + " to " + localName);
            if (this.findArg("ignoreerror") == null || !this.findArg("ignoreerror").equals("true")) {
                System.out.println("Response from DataPower: " + result);
                throw new RuntimeException("FAILED to download " + remoteName + " to " + localName);
            }
        }
    }

    public class Arg {
        String name;
        String value;

        public Arg(String name) {
            this.name = name;
        }

        public Arg(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public void addText(String text) {
            this.value = text;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

