/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.SomaUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class taskXpath
extends MatchingTask {
    private String inProp = "";
    private String outProp = "";
    private String inFile = "";
    private String outFile = "";
    private String xpath = "";
    private String xpathType = "";

    public void setInprop(String propname) {
        this.inProp = propname;
    }

    public void setOutprop(String propname) {
        this.outProp = propname;
    }

    public void setInfile(String filename) {
        this.inFile = filename;
    }

    public void setOutfile(String filename) {
        this.outFile = filename;
    }

    public void setXpath(String text) {
        this.xpath = text;
    }

    public void setXpathtype(String text) {
        this.xpathType = text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Project proj = this.getProject();
        try {
            NodeList nl;
            if ((this.inProp + this.inFile).length() == 0 || this.inProp != "" && this.inFile != "") {
                throw new BuildException("The <xpath> task requires XML either from an ANT property (inprop) or a file/url (infile), which are mutually exclusive.");
            }
            if ((this.outProp + this.outFile).length() == 0 || this.outProp != "" && this.outFile != "") {
                throw new BuildException("The <xpath> task requires a place to write the result, either an ANT property (outprop) or a file (outfile), or both.");
            }
            if (this.xpath.length() == 0) {
                throw new BuildException("The <xpath> task requires an XPath expression as its content.");
            }
            String xml = "";
            if (this.inProp != "") {
                xml = proj.getProperty(this.inProp);
            } else {
                File file = new File(this.inFile);
                byte[] buffer = new byte[(int)file.length()];
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.inFile));){
                    input.read(buffer);
                }
                xml = new String(buffer);
            }
            Node node = SomaUtils.getDOM(xml);
            String xpathResult = "";
            if (this.xpathType != null && this.xpathType.equals("node")) {
                xpathResult = SomaUtils.xmlNoHeader(SomaUtils.serializeXML(SomaUtils.nodeXpathFor(node, this.xpath)));
            } else if ("nodelist".equals(this.xpathType)) {
                nl = SomaUtils.nodelistXpathFor(node, this.xpath);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < nl.getLength(); ++i) {
                    sb.append(SomaUtils.xmlNoHeader(SomaUtils.serializeXML(nl.item(i))));
                }
                xpathResult = sb.toString();
            } else if ("list".equals(this.xpathType)) {
                nl = SomaUtils.nodelistXpathFor(node, this.xpath);
                if (nl.getLength() < 1) {
                    xpathResult = "";
                } else {
                    StringBuffer sb = new StringBuffer();
                    sb.append(nl.item(0).getTextContent());
                    for (int i = 1; i < nl.getLength(); ++i) {
                        sb.append("," + nl.item(i).getTextContent());
                    }
                    xpathResult = sb.toString();
                }
            } else {
                xpathResult = SomaUtils.stringXpathFor(node, this.xpath);
            }
            if (this.outProp != "") {
                proj.setProperty(this.outProp, xpathResult);
            }
            if (this.outFile != "") {
                FileOutputStream out = new FileOutputStream(this.outFile);
                ((OutputStream)out).write(xpathResult.getBytes());
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

