/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dcm;

import com.ibm.dcm.SomaUtils;
import com.ibm.dcm.XSLCache;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.XMLFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class taskNxslt
extends XMLFragment {
    private String inProp = "";
    private String outProp = "";
    private String inFile = "";
    private String outFile = "";
    private String xslFile = "";

    public void setInprop(String propname) {
        this.inProp = propname;
    }

    public void setOutprop(String propname) {
        this.outProp = propname;
    }

    public void setInfile(String filename) {
        this.inFile = filename;
    }

    public void setOutfile(String filename) {
        this.outFile = filename;
    }

    public void setXsl(String text) {
        this.xslFile = text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Project proj = this.getProject();
        try {
            if ((this.outProp + this.outFile).length() == 0 || this.outProp != "" && this.outFile != "") {
                throw new BuildException("The <nxslt> task requires a place to write the result, either an ANT property (outprop) or a file (outfile), or both.");
            }
            if (this.xslFile.length() == 0) {
                throw new BuildException("The <nxslt> task requires an XSL filename.");
            }
            String xml = "<null/>";
            if (this.inProp != "") {
                xml = proj.getProperty(this.inProp);
            } else if (this.inFile != "") {
                File file = new File(this.inFile);
                byte[] buffer = new byte[(int)file.length()];
                try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.inFile));){
                    input.read(buffer);
                }
                xml = new String(buffer);
            }
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            Transformer xform = XSLCache.getTransformer(this.getProject(), this.xslFile);
            StringWriter outstring = new StringWriter();
            xform.clearParameters();
            NodeList kids = this.getFragment().getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node node = kids.item(i);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("param")) continue;
                String ant = ((Element)node).getAttribute("ant");
                String xsl = ((Element)node).getAttribute("xsl");
                if (ant.length() <= 0 || xsl.length() <= 0) continue;
                String obj = proj.getProperty(ant);
                if (obj == null) {
                    obj = ant;
                }
                xform.setParameter(xsl, obj);
            }
            String source = this.inFile;
            if (this.inProp != "") {
                source = this.inProp;
            }
            String destination = this.outFile;
            if (this.outProp != "" && this.outFile != "") {
                destination = this.outProp + " and " + this.outFile;
            } else if (this.outProp != "") {
                destination = this.outProp;
            }
            System.out.println("nxslt running " + this.xslFile + " on " + source + " producing " + destination);
            xform.transform(new DOMSource(doc), new StreamResult(outstring));
            if (this.outProp != "") {
                proj.setProperty(this.outProp, SomaUtils.xmlNoHeader(outstring.toString()));
            }
            if (this.outFile != "") {
                FileOutputStream out = new FileOutputStream(this.outFile);
                ((OutputStream)out).write(outstring.toString().getBytes());
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

