/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.plugin.datastage.DataStageHelper;
import com.urbancode.air.plugin.datastage.TextBoxParser;

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

DataStageHelper helper = new DataStageHelper()
TextBoxParser tBox = new TextBoxParser()

 // dscmdimport Properties
def dsScriptPath = props['dsScriptPath']
def DSXFiles     = tBox.readFileorTextString(props['DSXFile'])

//Construct helper objects
def workDir = new File(".")
def ch = new CommandHelper(workDir)
final def isWindows = System.getProperty('os.name').contains("Windows")

// Construct and find the location of the DataStage script
def dsScript = isWindows ? "DSXImportService.bat" : "DSXImportService.sh"
def fullScriptPath = dsScriptPath + File.separator + dsScript
File scriptFile = new File(fullScriptPath)
if (!scriptFile.isFile()) {
    throw new Exception ("${fullScriptPath} does not exist!")
}

// Check that all files end with a DSX extension
helper.checkDSXExtensions(DSXFiles)

def exitCodes = []
// Loop through each DSX file and construct the DSXImportService command for each
for (DSXFile in DSXFiles) {
    def args = [fullScriptPath]
    args << "-List"

    // Does file exist?
    File dsxFile = new File(DSXFile)
    if (dsxFile.isFile()) {
        args << "-DSXFile"
        args << DSXFile

        // Successfully found! Run Command!
        println "Command: " + args.toString()
        exitCodes << ch.runCommand("Running list DSX command...", args)

    // DSX file was not found
    } else {
        println "Error: ${DSXFile} does not exist!"
        exitCodes << -1
    }

    println "==========================================================================================="
}

// If exitCodes contains a -1, we know something failed at some point
if (exitCodes.contains(-1)) {
    System.exit(1)
}

